/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class OSStats
extends AbstractStats {
    private StatValue openFiles;
    private StatValue maxOpenFiles;
    private StatValue minOpenFiles;
    private StatValue maxSupportedOpenFiles;
    private StatValue processCpuTime;
    private StatValue processTotalCpuTime;
    private StatValue freePhysicalMemory;
    private StatValue totalPhysicalMemory;
    private StatValue processors;
    private StatValue processCpuLoad;
    private StatValue systemCpuLoad;
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("FREE", "TOTAL", "FREE MB", "TOTAL MB", "Open Files", "Min Open Files", "Max Open Files", "Map supported Open Files", "CPU TIME", "Total CPU TIME", "Processors", "ProcessCPULoad", "SystemCPULoad"));

    public OSStats() {
        this("OS", Constants.getDefaultIntervals());
    }

    public OSStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public OSStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.openFiles = StatValueFactory.createStatValue(0, "openFiles", selectedIntervals);
        this.maxOpenFiles = StatValueFactory.createStatValue(0, "maxOpenFiles", selectedIntervals);
        this.maxOpenFiles.setDefaultValueAsLong(Integer.MIN_VALUE);
        this.maxOpenFiles.reset();
        this.minOpenFiles = StatValueFactory.createStatValue(0, "minOpenFiles", selectedIntervals);
        this.minOpenFiles.setDefaultValueAsLong(Integer.MAX_VALUE);
        this.minOpenFiles.reset();
        this.maxSupportedOpenFiles = StatValueFactory.createStatValue(0, "minOpenFiles", selectedIntervals);
        this.processCpuTime = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "processCpuTime", selectedIntervals);
        this.processTotalCpuTime = StatValueFactory.createStatValue(0L, "processTotalCpuTime", selectedIntervals);
        this.freePhysicalMemory = StatValueFactory.createStatValue(0L, "freePhysicalMemory", selectedIntervals);
        this.totalPhysicalMemory = StatValueFactory.createStatValue(0L, "totalPhysicalMemory", selectedIntervals);
        this.processors = StatValueFactory.createStatValue(0, "processors", selectedIntervals);
        this.processCpuLoad = StatValueFactory.createStatValue(0.0, "processCpuLoad", selectedIntervals);
        this.systemCpuLoad = StatValueFactory.createStatValue(0.0, "systemCpuLoad", selectedIntervals);
        this.addStatValues(this.openFiles, this.maxOpenFiles, this.minOpenFiles, this.maxSupportedOpenFiles, this.processCpuTime, this.processTotalCpuTime, this.freePhysicalMemory, this.totalPhysicalMemory, this.processors, this.processCpuLoad, this.systemCpuLoad);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getName()).append(' ');
        ret.append(" openfiles: ").append(this.openFiles.getValueAsInt(intervalName));
        ret.append(" maxopenfiles: ").append(this.openFiles.getValueAsInt(intervalName));
        ret.append(" minopenfiles: ").append(this.openFiles.getValueAsInt(intervalName));
        ret.append(" maxallowedopenfiles: ").append(this.maxSupportedOpenFiles.getValueAsInt(intervalName));
        ret.append(" cputime: ").append(this.processCpuTime.getValueAsLong(intervalName));
        ret.append(" totalcputime: ").append(this.processTotalCpuTime.getValueAsLong(intervalName));
        ret.append(" freemem: ").append(this.freePhysicalMemory.getValueAsLong(intervalName));
        ret.append(" totalmem: ").append(this.totalPhysicalMemory.getValueAsLong(intervalName));
        ret.append(" processors: ").append(this.processors.getValueAsInt(intervalName));
        ret.append(" processcpuload: " + this.processCpuLoad.getValueAsDouble(intervalName));
        ret.append(" systemcpuload: " + this.systemCpuLoad.getValueAsDouble(intervalName));
        return ret.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            throw new AssertionError((Object)"Value name can't be null");
        }
        if ((valueName = valueName.toLowerCase()).equals("free memory") || valueName.equals("free")) {
            return String.valueOf(this.getFreePhysicalMemory(intervalName));
        }
        if (valueName.equals("total memory") || valueName.equals("total")) {
            return String.valueOf(this.getTotalPhysicalMemory(intervalName));
        }
        if (valueName.equals("free memory mb") || valueName.equals("free mb")) {
            return String.valueOf(this.getFreePhysicalMemory(intervalName) / 0x100000L);
        }
        if (valueName.equals("total memory mb") || valueName.equals("total mb")) {
            return String.valueOf(this.getTotalPhysicalMemory(intervalName) / 0x100000L);
        }
        if (valueName.equals("openfiles") || valueName.equals("open files")) {
            return String.valueOf(this.getOpenFiles(intervalName));
        }
        if (valueName.equals("minopenfiles") || valueName.equals("min open files")) {
            return String.valueOf(this.getMinOpenFiles(intervalName));
        }
        if (valueName.equals("maxopenfiles") || valueName.equals("max open files")) {
            return String.valueOf(this.getMaxOpenFiles(intervalName));
        }
        if (valueName.equals("maxsupportedopenfiles") || valueName.equals("max supported open files")) {
            return String.valueOf(this.getMaxSupportedOpenFiles(intervalName));
        }
        if (valueName.equals("cputime") || valueName.equals("cpu time")) {
            return String.valueOf(this.getProcessCPUTime(intervalName));
        }
        if (valueName.equals("total cputime") || valueName.equals("total cpu time") || valueName.equals("totalcputime")) {
            return String.valueOf(this.getProcessTotalCPUTime(intervalName));
        }
        if (valueName.equals("processors")) {
            return String.valueOf(this.getProcessors(intervalName));
        }
        if (valueName.equals("processload") || valueName.equals("processcpuload")) {
            return String.valueOf(this.getProcessCpuLoad(intervalName));
        }
        if (valueName.equals("systemload") || valueName.equals("systemcpuload")) {
            return String.valueOf(this.getSystemCpuLoad(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    public void update(int anOpenFiles, int aMaxOpenFiles, long aFreePhysicalMemorySize, long aTotalPhysicalMemorySize, long aProcessTime, int aProcessors, double aProcessCpuLoad, double aSystemCpuLoad) {
        this.openFiles.setValueAsInt(anOpenFiles);
        this.maxOpenFiles.setValueIfGreaterThanCurrentAsInt(anOpenFiles);
        this.minOpenFiles.setValueIfLesserThanCurrentAsInt(anOpenFiles);
        this.maxSupportedOpenFiles.setValueAsInt(aMaxOpenFiles);
        this.processTotalCpuTime.setValueAsLong(aProcessTime);
        this.processCpuTime.setValueAsLong(aProcessTime);
        this.processors.setValueAsLong(aProcessors);
        this.freePhysicalMemory.setValueAsLong(aFreePhysicalMemorySize);
        this.totalPhysicalMemory.setValueAsLong(aTotalPhysicalMemorySize);
        this.processCpuLoad.setValueAsDouble(this.toPercent(aProcessCpuLoad));
        this.systemCpuLoad.setValueAsDouble(this.toPercent(aSystemCpuLoad));
    }

    private double toPercent(double val) {
        return (double)((int)(val * 10000.0)) / 100.0;
    }

    public int getOpenFiles(String intervalName) {
        return this.openFiles.getValueAsInt(intervalName);
    }

    public int getMaxOpenFiles(String intervalName) {
        return this.maxOpenFiles.getValueAsInt(intervalName);
    }

    public int getMinOpenFiles(String intervalName) {
        return this.minOpenFiles.getValueAsInt(intervalName);
    }

    public int getMaxSupportedOpenFiles(String intervalName) {
        return this.maxSupportedOpenFiles.getValueAsInt(intervalName);
    }

    public long getProcessCPUTime(String intervalName) {
        return this.processCpuTime.getValueAsLong(intervalName);
    }

    public long getProcessTotalCPUTime(String intervalName) {
        return this.processTotalCpuTime.getValueAsLong(intervalName);
    }

    public int getProcessors(String intervalName) {
        return this.processors.getValueAsInt(intervalName);
    }

    public long getFreePhysicalMemory(String intervalName) {
        return this.freePhysicalMemory.getValueAsLong(intervalName);
    }

    public long getTotalPhysicalMemory(String intervalName) {
        return this.totalPhysicalMemory.getValueAsLong(intervalName);
    }

    public double getProcessCpuLoad(String intervalName) {
        return this.processCpuLoad.getValueAsDouble(intervalName);
    }

    public double getSystemCpuLoad(String intervalName) {
        return this.systemCpuLoad.getValueAsDouble(intervalName);
    }
}

