/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.IMemoryPoolStats;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public abstract class AbstractMemoryPoolStats
extends AbstractStats
implements IMemoryPoolStats {
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("INIT", "MIN_USED", "USED", "MAX_USED", "MIN_COMMITED", "COMMITED", "MAX_COMMITED", "MAX"));

    protected AbstractMemoryPoolStats(String name) {
        super(name);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.isEmpty()) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("init")) {
            return String.valueOf(this.getInit(intervalName));
        }
        if (valueName.equals("min_used")) {
            return String.valueOf(this.getMinUsed(intervalName));
        }
        if (valueName.equals("used")) {
            return String.valueOf(this.getUsed(intervalName));
        }
        if (valueName.equals("used mb")) {
            return String.valueOf(this.getUsed(intervalName) / 0x100000L);
        }
        if (valueName.equals("max_used")) {
            return String.valueOf(this.getMaxUsed(intervalName));
        }
        if (valueName.equals("min_commited")) {
            return String.valueOf(this.getMinCommited(intervalName));
        }
        if (valueName.equals("commited")) {
            return String.valueOf(this.getCommited(intervalName));
        }
        if (valueName.equals("max_commited")) {
            return String.valueOf(this.getMaxCommited(intervalName));
        }
        if (valueName.equals("max")) {
            return String.valueOf(this.getMax(intervalName));
        }
        if (valueName.equals("max mb")) {
            return String.valueOf(this.getMax(intervalName) / 0x100000L);
        }
        if (valueName.equals("free")) {
            return String.valueOf(this.getFree(intervalName));
        }
        if (valueName.equals("free mb")) {
            return String.valueOf(this.getFree(intervalName) / 0x100000L);
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }
}

