/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.logging;

import net.anotheria.moskito.core.logging.ILogOutput;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.stats.IIntervalListener;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.util.Date;
import net.anotheria.util.IdCodeGenerator;

public class IntervalStatsLogger
implements IIntervalListener {
    private IStatsProducer<?> target;
    private Interval interval;
    private ILogOutput output;
    private String id;
    private TimeUnit unit;

    public IntervalStatsLogger(IStatsProducer aTarget, Interval anInterval, ILogOutput anOutput, TimeUnit unit) {
        this.target = aTarget;
        this.interval = anInterval;
        this.output = anOutput;
        this.interval.addSecondaryIntervalListener(this);
        this.id = IdCodeGenerator.generateCode((int)10);
        this.output.out("Started interval logger for " + this.interval.getName() + " for " + aTarget.getProducerId() + " / " + this.id);
    }

    public IntervalStatsLogger(IStatsProducer aTarget, Interval anInterval, ILogOutput anOutput) {
        this(aTarget, anInterval, anOutput, TimeUnit.MILLISECONDS);
    }

    @Override
    public void intervalUpdated(Interval caller) {
        this.output.out("===============================================================================");
        this.output.out("=== SNAPSHOT Interval " + this.interval.getName() + " updated, Entity: " + this.id);
        this.output.out("=== Timestamp: " + Date.currentDate() + ", ServiceId: " + this.target.getProducerId());
        this.output.out("===============================================================================");
        for (IStats stat : this.target.getStats()) {
            this.output.out(stat.toStatsString(this.interval.getName()));
        }
        this.output.out("===============================================================================");
        this.output.out("== END: Interval " + this.interval.getName() + ", Entity: " + this.id);
        this.output.out("===============================================================================");
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }
}

