/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.logging;

import java.util.ConcurrentModificationException;
import net.anotheria.moskito.core.logging.ILogOutput;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.timing.IUpdateable;
import net.anotheria.moskito.core.timing.UpdateTriggerServiceFactory;
import net.anotheria.util.Date;
import net.anotheria.util.IdCodeGenerator;
import org.slf4j.LoggerFactory;

public class DefaultStatsLogger
implements IUpdateable {
    private IStatsProducer<?> target;
    private ILogOutput output;
    private String id;
    private int outputIntervalInSeconds;

    public DefaultStatsLogger(IStatsProducer aTarget, ILogOutput anOutput) {
        this(aTarget, anOutput, 60);
    }

    public DefaultStatsLogger(IStatsProducer aTarget, ILogOutput anOutput, int anOutputIntervalInSeconds) {
        this.target = aTarget;
        this.output = anOutput;
        this.id = IdCodeGenerator.generateCode((int)10);
        this.outputIntervalInSeconds = anOutputIntervalInSeconds;
        UpdateTriggerServiceFactory.getUpdateTriggerService().addUpdateable(this, this.outputIntervalInSeconds);
        this.output.out("Started default interval logger for " + aTarget.getProducerId() + " / " + this.id);
    }

    @Override
    public void update() {
        this.output.out("===============================================================================");
        this.output.out("=== SNAPSHOT Interval DEFAULT " + this.outputIntervalInSeconds + "s, Entity: " + this.id);
        this.output.out("=== Timestamp: " + Date.currentDate() + ", ServiceId: " + this.target.getProducerId());
        this.output.out("===============================================================================");
        try {
            for (IStats stat : this.target.getStats()) {
                this.output.out(stat.toStatsString());
            }
        }
        catch (ConcurrentModificationException e) {
            LoggerFactory.getLogger(DefaultStatsLogger.class).warn("Error during iteration over stats from producer " + this.target + " (" + this.target.getClass() + "), concurrent modification of stats detected.");
        }
        this.output.out("===============================================================================");
        this.output.out("== END: DEFAULT Interval " + this.outputIntervalInSeconds + "s update, Entity: " + this.id);
        this.output.out("===============================================================================");
    }
}

