/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.decorators.AbstractDecorator;
import net.anotheria.moskito.core.decorators.value.LongValueAO;
import net.anotheria.moskito.core.decorators.value.StatValueAO;
import net.anotheria.moskito.core.predefined.MemoryStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.stats.TimeUnit;

public class MemoryStatsDecorator
extends AbstractDecorator {
    private static final long MB = 0x100000L;
    private static final String[] CAPTIONS = new String[]{"Current", "Min", "Max", "Current Mb", "Min Mb", "Max Mb"};
    private static final String[] SHORT_EXPLANATIONS = new String[]{"Current amount of memory", "Minimum amount of memory", "Maximum amount of memory", "Current amount of memory in Mb", "Minimum amount of memory in Mb", "Maximum amount of memory in Mb"};
    private static final String[] EXPLANATIONS = new String[]{"Current amount of memory", "Minimum amount of memory", "Maximum amount of memory", "Current amount of memory in Mb", "Minimum amount of memory in Mb", "Maximum amount of memory in Mb"};

    public MemoryStatsDecorator() {
        super("Memory", CAPTIONS, SHORT_EXPLANATIONS, EXPLANATIONS);
    }

    @Override
    public List<StatValueAO> getValues(IStats statsObject, String interval, TimeUnit unit) {
        MemoryStats stats = (MemoryStats)statsObject;
        ArrayList<StatValueAO> ret = new ArrayList<StatValueAO>(CAPTIONS.length);
        int i = 0;
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getCurrent(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getMin(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getMax(interval)));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getCurrent(interval) / 0x100000L));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getMin(interval) / 0x100000L));
        ret.add(new LongValueAO(CAPTIONS[i++], stats.getMax(interval) / 0x100000L));
        return ret;
    }
}

