/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.decorators;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.moskito.core.counter.CounterStats;
import net.anotheria.moskito.core.counter.GuestBasicPremiumStats;
import net.anotheria.moskito.core.counter.MaleFemaleStats;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.decorators.IDecoratorRegistry;
import net.anotheria.moskito.core.decorators.counter.CounterStatsDecorator;
import net.anotheria.moskito.core.decorators.counter.GuestBasicPremiumStatsDecorator;
import net.anotheria.moskito.core.decorators.counter.MaleFemaleStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.ActionStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.CacheStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.FilterStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.GenericStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.MemoryPoolStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.MemoryStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.OSStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.PageInBrowserStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.RuntimeStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.ServiceStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.ServletStatsDecorator;
import net.anotheria.moskito.core.decorators.predefined.ThreadCountDecorator;
import net.anotheria.moskito.core.decorators.predefined.ThreadStatesDecorator;
import net.anotheria.moskito.core.decorators.util.SessionCountDecorator;
import net.anotheria.moskito.core.decorators.util.StorageStatsDecorator;
import net.anotheria.moskito.core.predefined.ActionStats;
import net.anotheria.moskito.core.predefined.CacheStats;
import net.anotheria.moskito.core.predefined.FilterStats;
import net.anotheria.moskito.core.predefined.MemoryPoolStats;
import net.anotheria.moskito.core.predefined.MemoryStats;
import net.anotheria.moskito.core.predefined.OSStats;
import net.anotheria.moskito.core.predefined.PageInBrowserStats;
import net.anotheria.moskito.core.predefined.RuntimeStats;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.predefined.ServletStats;
import net.anotheria.moskito.core.predefined.ThreadCountStats;
import net.anotheria.moskito.core.predefined.ThreadStateStats;
import net.anotheria.moskito.core.predefined.VirtualMemoryPoolStats;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.util.session.SessionCountStats;
import net.anotheria.moskito.core.util.storage.StorageStats;

public class DecoratorRegistryImpl
implements IDecoratorRegistry {
    private Map<String, IDecorator> registry = new ConcurrentHashMap<String, IDecorator>();

    @Override
    public IDecorator getDecorator(IStats stats) {
        return this.getDecorator(stats.getClass().getName());
    }

    @Override
    public IDecorator getDecorator(Class<? extends IStats> statsClazz) {
        return this.getDecorator(statsClazz.getName());
    }

    @Override
    public IDecorator getDecorator(String className) {
        IDecorator specificDecorator = this.registry.get(className);
        if (specificDecorator == null) {
            specificDecorator = new GenericStatsDecorator(className);
            this.addDecorator(className, specificDecorator);
        }
        return specificDecorator;
    }

    @Override
    public List<IDecorator> getDecorators() {
        ArrayList<IDecorator> ret = new ArrayList<IDecorator>(this.registry.values());
        return ret;
    }

    DecoratorRegistryImpl() {
        this.configure();
    }

    private void configure() {
        this.addDecorator(ServiceStats.class, (IDecorator)new ServiceStatsDecorator());
        this.addDecorator(ActionStats.class, (IDecorator)new ActionStatsDecorator());
        this.addDecorator(ServletStats.class, (IDecorator)new ServletStatsDecorator());
        this.addDecorator(FilterStats.class, (IDecorator)new FilterStatsDecorator());
        this.addDecorator(CacheStats.class, (IDecorator)new CacheStatsDecorator());
        this.addDecorator(StorageStats.class, (IDecorator)new StorageStatsDecorator());
        this.addDecorator(MemoryStats.class, (IDecorator)new MemoryStatsDecorator());
        this.addDecorator(MemoryPoolStats.class, (IDecorator)new MemoryPoolStatsDecorator());
        this.addDecorator(VirtualMemoryPoolStats.class, (IDecorator)new MemoryPoolStatsDecorator("VirtualMemoryPool"));
        this.addDecorator(ThreadCountStats.class, (IDecorator)new ThreadCountDecorator());
        this.addDecorator(ThreadStateStats.class, (IDecorator)new ThreadStatesDecorator());
        this.addDecorator(OSStats.class, (IDecorator)new OSStatsDecorator());
        this.addDecorator(RuntimeStats.class, (IDecorator)new RuntimeStatsDecorator());
        this.addDecorator(PageInBrowserStats.class, (IDecorator)new PageInBrowserStatsDecorator());
        this.addDecorator(CounterStats.class, (IDecorator)new CounterStatsDecorator());
        this.addDecorator(MaleFemaleStats.class, (IDecorator)new MaleFemaleStatsDecorator());
        this.addDecorator(GuestBasicPremiumStats.class, (IDecorator)new GuestBasicPremiumStatsDecorator());
        this.addDecorator(SessionCountStats.class, (IDecorator)new SessionCountDecorator());
    }

    @Override
    public void addDecorator(Class<? extends AbstractStats> clazz, IDecorator decorator) {
        this.addDecorator(clazz.getName(), decorator);
    }

    @Override
    public void addDecorator(String clazzName, IDecorator decorator) {
        this.registry.put(clazzName, decorator);
    }
}

