/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config.accumulators;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import net.anotheria.moskito.core.config.accumulators.AccumulatorConfig;
import net.anotheria.moskito.core.config.accumulators.AccumulatorGraphColor;
import net.anotheria.moskito.core.config.accumulators.AccumulatorSetConfig;
import net.anotheria.util.StringUtils;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;

@ConfigureMe
@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"}, justification="This is the way configureme works, it provides beans for access")
public class AccumulatorsConfig
implements Serializable {
    private static final long serialVersionUID = -2579727416537790538L;
    @Configure
    private int accumulationAmount = 200;
    @Configure
    private AccumulatorConfig[] accumulators;
    @Configure
    private AccumulatorSetConfig[] accumulatorSets;
    @Configure
    private AccumulatorGraphColor[] accumulatorsColors;

    public AccumulatorConfig[] getAccumulators() {
        return this.accumulators;
    }

    public void setAccumulators(AccumulatorConfig[] accumulators) {
        this.accumulators = accumulators;
    }

    public int getAccumulationAmount() {
        return this.accumulationAmount;
    }

    public void setAccumulationAmount(int accumulationAmount) {
        this.accumulationAmount = accumulationAmount;
    }

    public AccumulatorSetConfig[] getAccumulatorSets() {
        return this.accumulatorSets;
    }

    public void setAccumulatorSets(AccumulatorSetConfig[] accumulatorSets) {
        this.accumulatorSets = accumulatorSets;
    }

    public AccumulatorGraphColor[] getAccumulatorsColors() {
        return this.accumulatorsColors;
    }

    public void setAccumulatorsColors(AccumulatorGraphColor[] accumulatorsColors) {
        this.accumulatorsColors = accumulatorsColors;
    }

    public String getAccumulatorColor(String accumulatorName) {
        if (StringUtils.isEmpty((String)accumulatorName)) {
            throw new IllegalArgumentException("accumulatorName is null");
        }
        if (this.accumulatorsColors == null || this.accumulatorsColors.length == 0) {
            return null;
        }
        for (AccumulatorGraphColor accumulator : this.accumulatorsColors) {
            if (!accumulatorName.equals(accumulator.getName())) continue;
            return accumulator.getColor();
        }
        return null;
    }

    public String toString() {
        return "Amount: " + this.accumulationAmount + ", " + "accumulators: " + Arrays.toString(this.accumulators) + ", accumulatorSets: " + Arrays.toString(this.accumulatorSets) + ", accumulatorsColors: " + Arrays.toString(this.accumulatorsColors);
    }
}

