/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.anotheria.moskito.core.config.MoskitoConfiguration;
import org.configureme.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MoskitoConfigurationHolder {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(MoskitoConfigurationHolder.class);
    private volatile MoskitoConfiguration configuration = MoskitoConfigurationHolder.createDefaultConfiguration();

    private MoskitoConfigurationHolder() {
        try {
            ConfigurationManager.INSTANCE.configure((Object)this.configuration);
        }
        catch (IllegalArgumentException e) {
            this.log.info("MoSKito configuration not found, working with default configuration, visit https://confluence.opensource.anotheria.net/display/MSK/Configuration+Guide for more details.");
        }
    }

    private static MoskitoConfiguration createDefaultConfiguration() {
        MoskitoConfiguration config = new MoskitoConfiguration();
        config.getThresholdsAlertsConfig().getAlertHistoryConfig().setMaxNumberOfItems(200);
        config.getThresholdsAlertsConfig().getAlertHistoryConfig().setToleratedNumberOfItems(220);
        config.getThresholdsAlertsConfig().setDispatcherThreadPoolSize(1);
        config.getAccumulatorsConfig().setAccumulationAmount(200);
        return config;
    }

    public static MoskitoConfiguration getConfiguration() {
        return MoskitoConfigurationHolder.INSTANCE.configuration;
    }

    @SuppressFBWarnings(value={"ME_ENUM_FIELD_SETTER"})
    public void setConfiguration(MoskitoConfiguration configuration) {
        this.configuration = configuration;
    }

    public static void resetConfiguration() {
        MoskitoConfigurationHolder.INSTANCE.configuration = MoskitoConfigurationHolder.createDefaultConfiguration();
    }
}

