/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.calltrace;

import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.NoTracedCall;
import net.anotheria.moskito.core.calltrace.TracedCall;

public class RunningTraceContainer {
    private static ThreadLocal<TracedCall> currentlyTracedCall = new ThreadLocal<TracedCall>(){

        @Override
        protected synchronized TracedCall initialValue() {
            return NoTracedCall.INSTANCE;
        }
    };

    public static TracedCall getCurrentlyTracedCall() {
        return currentlyTracedCall.get();
    }

    public static void startTracedCall(String name) {
        currentlyTracedCall.set(new CurrentlyTracedCall(name));
    }

    public static void setCurrentlyTracedCall(TracedCall aTracedCall) {
        currentlyTracedCall.set(aTracedCall);
    }

    public static TracedCall endTrace() {
        TracedCall last = RunningTraceContainer.getCurrentlyTracedCall();
        RunningTraceContainer.setCurrentlyTracedCall(NoTracedCall.INSTANCE);
        return last;
    }

    public static void cleanup() {
        currentlyTracedCall.remove();
    }

    public static boolean isTraceRunning() {
        return currentlyTracedCall.get().callTraced();
    }
}

