/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.blueprint;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.moskito.core.blueprint.BlueprintProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintProducersFactory {
    private static Logger log = LoggerFactory.getLogger(BlueprintProducersFactory.class);
    private static final Map<String, BlueprintProducer> producers = new HashMap<String, BlueprintProducer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlueprintProducer getBlueprintProducer(String producerId, String category, String subsystem) {
        try {
            BlueprintProducer producer = producers.get(producerId);
            if (producer == null) {
                Map<String, BlueprintProducer> map = producers;
                synchronized (map) {
                    producer = producers.get(producerId);
                    if (producer == null) {
                        producer = new BlueprintProducer(producerId, category, subsystem);
                        producers.put(producerId, producer);
                    }
                }
            }
            return producer;
        }
        catch (Exception e) {
            log.error("getBlueprintProducer(" + producerId + ", " + category + ", " + subsystem + ')', (Throwable)e);
            throw new RuntimeException("Handler instantiation failed - " + e.getMessage());
        }
    }
}

