/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.util.xml.XMLHelper;

public class XMLNode {
    private List<XMLNode> nodes;
    private List<XMLAttribute> attributes;
    private String name;
    private String content;

    public XMLNode(String aName) {
        this.name = aName;
        this.attributes = new ArrayList<XMLAttribute>();
        this.nodes = new ArrayList<XMLNode>();
    }

    public List<XMLNode> getNodes() {
        return this.nodes;
    }

    public void setChildren(List<XMLNode> aChildren) {
        this.setNodes(aChildren);
    }

    public void setNodes(List<XMLNode> aNodes) {
        this.nodes = aNodes;
    }

    public void addChildNode(XMLNode aChild) {
        this.nodes.add(aChild);
    }

    public List<XMLAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<XMLAttribute> aAttributes) {
        this.attributes = aAttributes;
    }

    public void addAttribute(XMLAttribute aAttribute) {
        this.attributes.add(aAttribute);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String aContent) {
        this.content = aContent;
    }

    public void setContent(boolean aContent) {
        this.setContent("" + aContent);
    }

    public void setContent(float aContent) {
        this.setContent("" + aContent);
    }

    public void setContent(double aContent) {
        this.setContent("" + aContent);
    }

    public void setContent(long aContent) {
        this.setContent("" + aContent);
    }

    public void setContent(int aContent) {
        this.setContent("" + aContent);
    }

    public void setContent(List<Object> aL) {
        this.setContent(aL.toString());
    }

    public String toString() {
        return "name: " + this.name + ", " + " attributes: " + this.attributes + ", nodes: " + this.nodes;
    }

    private String createAttributeString() {
        String ret = "";
        if (this.attributes == null || this.attributes.size() == 0) {
            return ret;
        }
        for (XMLAttribute a : this.attributes) {
            ret = ret + " " + a.toXMLString();
        }
        return ret;
    }

    public void write(PrintStream aWriter, int aTabs) throws IOException {
        String attributeString = this.createAttributeString();
        String ident = XMLHelper.makeIdent(aTabs);
        aWriter.println(ident + XMLHelper.entag(this.getName() + attributeString));
        for (XMLNode child : this.nodes) {
            child.write(aWriter, aTabs + 1);
        }
        if (this.content != null) {
            aWriter.println(XMLHelper.makeIdent(aTabs + 1) + "<![CDATA[" + this.content + "]]>\n");
        }
        aWriter.println(ident + XMLHelper.detag(this.getName()));
    }

    public void write(PrintWriter aWriter, int aTabs) throws IOException {
        String attributeString = this.createAttributeString();
        String ident = XMLHelper.makeIdent(aTabs);
        aWriter.write(ident + XMLHelper.entag(this.getName() + attributeString));
        for (XMLNode child : this.nodes) {
            child.write(aWriter, aTabs + 1);
        }
        if (this.content != null) {
            aWriter.write(XMLHelper.makeIdent(aTabs + 1) + "<![CDATA[" + this.content + "]]>\n");
        }
        aWriter.write(ident + XMLHelper.detag(this.getName()));
    }

    public void write(OutputStreamWriter aWriter, int aTabs) throws IOException {
        try {
            String attributeString = this.createAttributeString();
            String ident = XMLHelper.makeIdent(aTabs);
            aWriter.write(ident + XMLHelper.entag(this.getName() + attributeString));
            for (XMLNode child : this.nodes) {
                child.write(aWriter, aTabs + 1);
            }
            if (this.content != null) {
                aWriter.write(XMLHelper.makeIdent(aTabs + 1) + "<![CDATA[" + this.content + "]]>\n");
            }
            aWriter.write(ident + XMLHelper.detag(this.getName()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void write(Writer aWriter, int aTabs) throws IOException {
        try {
            String attributeString = this.createAttributeString();
            String ident = XMLHelper.makeIdent(aTabs);
            aWriter.write(ident + XMLHelper.entag(this.getName() + attributeString));
            for (XMLNode child : this.nodes) {
                child.write(aWriter, aTabs + 1);
            }
            if (this.content != null) {
                aWriter.write(XMLHelper.makeIdent(aTabs + 1) + "<![CDATA[" + this.content + "]]>\n");
            }
            aWriter.write(ident + XMLHelper.detag(this.getName()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

