/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.tools.Worker;

public class Walker {
    private Worker worker;
    private int touched = 0;
    private int dirs = 0;
    private int files = 0;

    public Walker() {
    }

    public Walker(Worker aWorker) {
        this();
        this.setWorker(aWorker);
    }

    public void setWorker(Worker aWorker) {
        this.worker = aWorker;
    }

    public void start(List<String> directories) {
        if (this.worker == null) {
            throw new IllegalStateException("No worker configured!");
        }
        for (String directory : directories) {
            this.process(new File(directory));
        }
        System.out.println("Scanned file " + this.touched + ", directories: " + this.dirs + ", files: " + this.files);
    }

    public void start() {
        ArrayList<String> toDo = new ArrayList<String>(1);
        toDo.add(".");
        this.start(toDo);
    }

    private void process(File f) {
        ++this.touched;
        if (this.touched / 10000 * 10000 == this.touched) {
            System.out.println("Scanning file " + this.touched + ", directories: " + this.dirs + ", files: " + this.files);
        }
        if (f.isDirectory()) {
            this.processDir(f);
        } else {
            this.processFile(f);
        }
    }

    private void processFile(File f) {
        ++this.files;
        this.worker.processFile(f);
    }

    private void processDir(File f) {
        File[] ff;
        ++this.dirs;
        for (File file : ff = f.listFiles()) {
            this.process(file);
        }
    }
}

