/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.anotheria.util.StringUtils;
import net.anotheria.util.tools.Walker;
import net.anotheria.util.tools.Worker;

public final class WC {
    private static final String EXT = ".java";
    private static int totalLines;
    private static int totalWords;
    private static int totalChars;
    private static int totalFiles;

    public static void main(String[] a) {
        totalChars = 0;
        totalWords = 0;
        totalLines = 0;
        totalFiles = 0;
        if (a.length == 0) {
            a = new String[]{"."};
        }
        List<String> toCheck = Arrays.asList(a);
        new Walker(new WCWorker()).start(toCheck);
        System.out.println("Total files:" + totalFiles + " C:" + totalChars + ", W:" + totalWords + " L:" + totalLines);
    }

    private WC() {
    }

    private static class WCWorker
    implements Worker {
        private WCWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processFile(File file) {
            if (!file.getName().endsWith(WC.EXT)) {
                return;
            }
            FileInputStream fIn = null;
            System.out.print("Checking " + file.getAbsolutePath() + " ");
            try {
                fIn = new FileInputStream(file);
                byte[] d = new byte[fIn.available()];
                fIn.read(d);
                String s = new String(d);
                s = StringUtils.removeChar(s, '\r');
                s = StringUtils.removeCComments(s);
                s = StringUtils.removeCPPComments(s);
                boolean inWord = false;
                int chars = 0;
                int lines = 0;
                int words = 0;
                String currentLine = "";
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == ' ' || c == '\t' || c == '\n') {
                        if (inWord) {
                            inWord = false;
                        }
                    } else {
                        ++chars;
                        currentLine = currentLine + c;
                        if (!inWord) {
                            inWord = true;
                            ++words;
                        }
                    }
                    if (c != '\n') continue;
                    if (currentLine.length() > 0 && !currentLine.startsWith("import") && !currentLine.startsWith("package")) {
                        ++lines;
                    }
                    currentLine = new String("");
                }
                System.out.print(" C: " + chars);
                System.out.print(" W: " + words);
                System.out.print(" L: " + lines);
                System.out.println();
                totalLines += lines;
                totalWords += words;
                totalChars += chars;
                totalFiles++;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fIn != null) {
                    try {
                        fIn.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

