/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.sorter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;

public final class StaticQuickSorter {
    public static <T extends IComparable> List<T> sort(Collection<T> source, SortType sType) {
        ArrayList<T> tmp = new ArrayList<T>(source.size());
        tmp.addAll(source);
        return StaticQuickSorter.sort(tmp, sType);
    }

    public static <T extends IComparable> List<T> sort(List<T> source, SortType sType) {
        boolean sortOrder = sType.getSortOrder();
        int sortAfter = sType.getSortBy();
        if (StaticQuickSorter.isSorted(source, sType)) {
            return source;
        }
        if (StaticQuickSorter.isSorted(source, sType.reverse())) {
            return StaticQuickSorter.upsideDown(source);
        }
        boolean wanted = sortOrder;
        StaticQuickSorter.sort(source, 0, source.size() - 1, wanted, sortAfter);
        return source;
    }

    private static <T extends IComparable> void sort(List<T> source, int start, int end, boolean wanted, int sortAfter) {
        if (start < end) {
            int mid = StaticQuickSorter.partition(source, start, end, wanted, sortAfter);
            StaticQuickSorter.sort(source, start, mid - 1, wanted, sortAfter);
            StaticQuickSorter.sort(source, mid + 1, end, wanted, sortAfter);
        }
    }

    private static <T extends IComparable> List<T> upsideDown(List<T> src) {
        if (src == null) {
            return null;
        }
        ArrayList<T> ret = new ArrayList<T>(src.size());
        for (int i = src.size() - 1; i >= 0; --i) {
            ret.add(src.get(i));
        }
        return ret;
    }

    private static <T extends IComparable> boolean isSorted(List<T> src, SortType type) {
        IComparable comp;
        boolean wanted = type.getSortOrder();
        int sortAfter = type.getSortBy();
        Iterator<T> elements = src.iterator();
        if (elements.hasNext()) {
            comp = (IComparable)elements.next();
        } else {
            return true;
        }
        while (elements.hasNext()) {
            IComparable comp2 = (IComparable)elements.next();
            if (wanted ? comp.compareTo(comp2, sortAfter) > 0 : comp.compareTo(comp2, sortAfter) < 0) {
                return false;
            }
            comp = comp2;
        }
        return true;
    }

    private static <T extends IComparable> int partition(List<T> source, int start, int end, boolean wanted, int sortAfter) {
        IComparable partElement = (IComparable)source.get(end);
        int left = start - 1;
        int right = end;
        while (true) {
            if ((wanted ? partElement.compareTo((IComparable)source.get(++left), sortAfter) > 0 : partElement.compareTo((IComparable)source.get(++left), sortAfter) < 0) && left != end) {
                continue;
            }
            while ((wanted ? partElement.compareTo((IComparable)source.get(--right), sortAfter) < 0 : partElement.compareTo((IComparable)source.get(--right), sortAfter) > 0) && right != start) {
            }
            if (left >= right) break;
            StaticQuickSorter.swap(source, left, right);
        }
        StaticQuickSorter.swap(source, left, end);
        return left;
    }

    private static <T extends IComparable> void swap(List<T> source, int i, int j) {
        IComparable tmp = (IComparable)source.get(i);
        source.set(i, source.get(j));
        source.set(j, tmp);
    }

    private StaticQuickSorter() {
    }
}

