/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.slicer;

import java.util.List;
import net.anotheria.util.slicer.Segment;

public class Slice<T> {
    private Segment segment;
    private int totalNumberOfItems;
    private int totalNumberOfSlices;
    private List<T> sliceData;

    public Slice(Segment aSegment) {
        this.segment = aSegment;
    }

    public Segment getSegment() {
        return this.segment;
    }

    void setSegment(Segment aSegment) {
        this.segment = aSegment;
    }

    public int getTotalNumberOfItems() {
        return this.totalNumberOfItems;
    }

    public void setTotalNumberOfItems(int aTotalNumberOfItems) {
        this.totalNumberOfItems = aTotalNumberOfItems;
    }

    public int getTotalNumberOfSlices() {
        return this.totalNumberOfSlices;
    }

    public void setTotalNumberOfSlices(int aTotalNumberOfSlices) {
        this.totalNumberOfSlices = aTotalNumberOfSlices;
    }

    public int getCurrentSlice() {
        return this.segment.getSliceNumber();
    }

    public int getElementsPerSlice() {
        return this.segment.getElementsPerSlice();
    }

    public List<T> getSliceData() {
        return this.sliceData;
    }

    public void setSliceData(List<T> someSliceData) {
        this.sliceData = someSliceData;
    }

    public String toString() {
        return "TOT I: " + this.totalNumberOfItems + ", TOT P: " + this.totalNumberOfSlices + ", SEG: {" + this.segment + "}, contents: " + this.sliceData;
    }

    public boolean hasNextSlice() {
        return this.getCurrentSlice() < this.getTotalNumberOfSlices();
    }

    public boolean hasPrevSlice() {
        return this.getCurrentSlice() > 1;
    }

    public boolean isFirstSlice() {
        return this.getCurrentSlice() == 1;
    }

    public boolean isLastSlice() {
        return this.getCurrentSlice() == this.totalNumberOfSlices;
    }
}

