/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.sizeof;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.util.StringUtils;
import net.anotheria.util.sizeof.ObjectHelper;
import net.anotheria.util.sizeof.SizeofHelper;
import net.anotheria.util.sizeof.StringHelper;
import test.sizeof.simple1.A;
import test.sizeof.simple1.C;

public class SizeofUtility {
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_BOOLEAN = 4;
    public static final int VM = 8;
    public static final int SIZEOF_REFERENCE = 8;
    public static final int SIZEOF_OBJECT_OVERHEAD = 16;
    private static Map<Class<?>, SizeofHelper> helpers = new HashMap();

    public static final int shortSizeof(Object o) throws Exception {
        return SizeofUtility.sizeof(o, false);
    }

    public static final int deepSizeof(Object o) throws Exception {
        return SizeofUtility.sizeof(o, true);
    }

    public static int sizeof(Object o, boolean deep) throws Exception {
        int ret = 0;
        Class<?> c = o.getClass();
        return ret += SizeofUtility.sizeofClazz(c, o);
    }

    private static int sizeofClazz(Class<?> c, Object o) throws Exception {
        int ret = 0;
        SizeofHelper helper = helpers.get(c);
        if (helper != null) {
            ret = helper.sizeof(o);
        } else {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod)) continue;
                boolean counted = false;
                if (f.getType().isPrimitive()) {
                    ret += SizeofUtility.sizeofPrimitive(f);
                    counted = true;
                }
                if (!counted && f.getType().isArray()) {
                    System.out.println("WARN! ARRAY! " + f.getName());
                    counted = true;
                }
                if (counted) continue;
                ret += 8;
                Object fieldValue = SizeofUtility.getObjectFromField(f, o);
                if (fieldValue == null) continue;
                ret += SizeofUtility.sizeofClazz(f.getType(), fieldValue);
            }
        }
        if (!c.getName().equals("java.lang.Object")) {
            ret += SizeofUtility.sizeofClazz(c.getSuperclass(), o);
        }
        return ret;
    }

    private static Object getObjectFromField(Field f, Object owner) throws Exception {
        String methodName;
        if (Modifier.isPublic(f.getModifiers())) {
            return f.get(owner);
        }
        Class<?> c = owner.getClass();
        Method m = c.getDeclaredMethod(methodName = "get" + StringUtils.capitalize(f.getName()), new Class[0]);
        if (m == null) {
            return null;
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            System.out.println("can't access method: " + methodName);
            return null;
        }
        return m.invoke(owner, new Object[0]);
    }

    private static int sizeofPrimitive(Field f) {
        Class<?> c = f.getType();
        String name = c.getName();
        if ("int".equals(name)) {
            return 4;
        }
        if ("long".equals(name)) {
            return 8;
        }
        if ("char".equals(name)) {
            return 2;
        }
        if ("byte".equals(name)) {
            return 1;
        }
        if ("float".equals(name)) {
            return 4;
        }
        if ("double".equals(name)) {
            return 8;
        }
        if ("short".equals(name)) {
            return 2;
        }
        if ("boolean".equals(name)) {
            return 4;
        }
        System.out.println("WARN - Unrecognized primitive type: " + f.getType());
        return 0;
    }

    public static void main(String[] a) throws Exception {
        SizeofUtility.test(new C());
    }

    private static void testList() throws Exception {
        ArrayList<A> list = new ArrayList<A>(2);
        list.add(new A());
        list.add(new A());
        SizeofUtility.test(list);
    }

    private static void test(Object o) throws Exception {
        int size = SizeofUtility.sizeof(o, true);
        System.out.println("Size of " + o + " is " + size);
        System.out.println("=======================");
    }

    private static void printMod(int mod) {
        SizeofUtility.printMod("abstract", Modifier.isAbstract(mod));
        SizeofUtility.printMod("final", Modifier.isFinal(mod));
        SizeofUtility.printMod("interface", Modifier.isInterface(mod));
        SizeofUtility.printMod("native", Modifier.isNative(mod));
        SizeofUtility.printMod("private", Modifier.isPrivate(mod));
        SizeofUtility.printMod("protected", Modifier.isProtected(mod));
        SizeofUtility.printMod("public", Modifier.isPublic(mod));
        SizeofUtility.printMod("static", Modifier.isStatic(mod));
        SizeofUtility.printMod("strict", Modifier.isStrict(mod));
        SizeofUtility.printMod("synchronized", Modifier.isSynchronized(mod));
        SizeofUtility.printMod("transient", Modifier.isTransient(mod));
        SizeofUtility.printMod("volatile", Modifier.isVolatile(mod));
    }

    private static void printMod(String s, boolean v) {
        if (v) {
            System.out.println("\t" + s);
        }
    }

    static {
        helpers.put(String.class, new StringHelper());
        helpers.put(Object.class, new ObjectHelper());
    }
}

