/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.resource;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.resource.ClassPathResourceLoader;
import net.anotheria.util.resource.ResourceListener;
import net.anotheria.util.resource.ResourceLoader;
import net.anotheria.util.resource.WatchDog;
import org.apache.log4j.Logger;

public class Resource {
    private String name;
    private String content;
    private List<ResourceListener> listeners;
    private long lastChangeTimestamp;
    private ResourceLoader resourceLoader;
    private static Logger log = Logger.getLogger(Resource.class);

    public Resource(String aName) {
        this(aName, false);
    }

    public Resource(String aName, boolean aWatch) {
        this(aName, new ClassPathResourceLoader(), aWatch);
    }

    public Resource(String aName, ResourceLoader aResourceLoader, boolean watch) {
        this.name = aName;
        this.resourceLoader = aResourceLoader;
        this.listeners = new ArrayList<ResourceListener>();
        this.lastChangeTimestamp = System.currentTimeMillis();
        this.reloadContent();
        if (watch) {
            WatchDog.INSTANCE.addResourceToWatch(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ResourceListener listener) {
        List<ResourceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ResourceListener listener) {
        List<ResourceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public String toString() {
        return "Resource " + this.name + ", listeners: " + this.listeners.size() + ", " + NumberUtils.makeISO8601TimestampString(this.getLastChangeTimestamp());
    }

    public long getLastChangeTimestamp() {
        return this.lastChangeTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    protected boolean isOlderAs(long resourceChangeTimestamp) {
        return this.lastChangeTimestamp < resourceChangeTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUpdateEvent(long timestamp) {
        this.reloadContent();
        List<ResourceListener> list = this.listeners;
        synchronized (list) {
            for (ResourceListener listener : this.listeners) {
                try {
                    log.debug((Object)("Calling configurationSourceUpdated on " + listener));
                    listener.resourceUpdated(this);
                }
                catch (Exception e) {
                    log.error((Object)("Error in notifying configuration source listener:" + listener), (Throwable)e);
                }
            }
        }
        this.lastChangeTimestamp = timestamp;
    }

    protected ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    private void reloadContent() {
        this.content = this.getResourceLoader().getContent(this.getName());
    }
}

