/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import net.anotheria.util.queue.IQueue;
import net.anotheria.util.queue.IQueueListener;
import net.anotheria.util.queue.QueueOverflowException;

public class QueueImpl<T>
implements IQueue<T> {
    private List<IQueueListener> listeners = new ArrayList<IQueueListener>();
    private ArrayBlockingQueue<T> underlyingQueue;
    private int size;

    QueueImpl(int aSize) {
        this.underlyingQueue = new ArrayBlockingQueue(aSize);
        this.size = aSize;
    }

    @Override
    public void addListener(IQueueListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public int getElementCount() {
        return this.underlyingQueue.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean hasElements() {
        return !this.underlyingQueue.isEmpty();
    }

    @Override
    public T nextElement() {
        if (!this.hasElements()) {
            throw new RuntimeException("No elements");
        }
        return this.underlyingQueue.poll();
    }

    @Override
    public void putElement(T o) throws QueueOverflowException {
        if (!this.underlyingQueue.offer(o)) {
            throw new QueueOverflowException("" + o);
        }
    }

    @Override
    public void removeListener(IQueueListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "queue count: " + this.getElementCount();
    }
}

