/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.network;

import net.anotheria.util.StringUtils;

public class IPRange {
    private long networkMask;
    private long maskedIp;

    public IPRange(String ipAdress, int mask) {
        this.maskedIp = this.convertIp(ipAdress);
        this.networkMask = (long)Math.pow(2.0, mask) - 1L;
        this.networkMask <<= 32 - mask;
        this.maskedIp &= this.networkMask;
    }

    public boolean mayPass(String ip) {
        long myIp = this.convertIp(ip);
        return (myIp & this.networkMask) == this.maskedIp;
    }

    private long convertIp(String ipAdress) {
        int i;
        long result = 0L;
        String[] tokens = StringUtils.tokenize(ipAdress, '.');
        if (tokens == null || tokens.length != 4) {
            throw new RuntimeException("Illegal ip format: " + ipAdress);
        }
        int[] ipAsByte = new int[4];
        for (i = 0; i < tokens.length; ++i) {
            ipAsByte[i] = Integer.parseInt(tokens[i]);
        }
        for (i = 0; i < ipAsByte.length; ++i) {
            if (i > 0) {
                result <<= 8;
            }
            result |= (long)ipAsByte[i];
        }
        return result;
    }

    public String toString() {
        return "nIP: " + this.maskedIp + ", nM: " + this.networkMask;
    }
}

