/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.log;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public final class LogMessageUtil {
    public static final String DELIMITER = ",";
    public static final String DELIMITER_LENGTH = "=";
    public static final String DELIMITER_MAP_ELEMENT = "=";
    public static final String STR_EMPTY = "";
    public static final String STR_FAIL = " fail.";
    public static final String STR_NULL = "null";
    public static final String STR_SKIP = "...";
    public static final String STR_UNKNOWN_METHOD = "UNKNOWN";
    public static final int MAX_ARGUMENT_LENGTH = 255;

    private LogMessageUtil() {
        throw new IllegalAccessError();
    }

    public static String failMsg(Throwable t, Object ... objects) {
        String methodName = STR_UNKNOWN_METHOD;
        StackTraceElement[] stes = t.getStackTrace();
        if (t != null && stes != null && stes.length > 0 && stes[0] != null) {
            methodName = stes[0].getMethodName();
        }
        if (objects == null || objects.length == 0) {
            return methodName + "()" + STR_FAIL;
        }
        StringBuffer arguments = new StringBuffer("(");
        int processed = 0;
        for (Object obj : objects) {
            if (processed > 0) {
                arguments.append(DELIMITER);
            }
            ++processed;
            if (obj == null) {
                arguments.append(STR_NULL);
                continue;
            }
            if (obj.toString().isEmpty()) {
                arguments.append(STR_EMPTY);
                continue;
            }
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                arguments.append(collection.size() + "=" + "[");
                arguments.append(LogMessageUtil.crop(LogMessageUtil.collectionToString(collection, true), 255));
                arguments.append("]");
                continue;
            }
            if (obj instanceof Map) {
                Map map = (Map)obj;
                arguments.append(map.size() + "=" + "{");
                arguments.append(LogMessageUtil.crop(LogMessageUtil.mapToString(map, true), 255));
                arguments.append("}");
                continue;
            }
            if (obj.getClass() != null && obj.getClass().isArray()) {
                int length = Array.getLength(obj);
                arguments.append(length + "=" + "[");
                arguments.append(LogMessageUtil.crop(LogMessageUtil.arrayToString(obj, true), 255));
                arguments.append("]");
                continue;
            }
            arguments.append(LogMessageUtil.crop(obj, 255));
        }
        arguments.append(")");
        return methodName + arguments.toString() + STR_FAIL;
    }

    private static String collectionToString(Collection<?> collection, boolean isTop) {
        if (collection == null) {
            return STR_NULL;
        }
        Object[] collectionArray = collection.toArray();
        int length = collectionArray.length;
        StringBuilder result = !isTop ? new StringBuilder("[") : new StringBuilder();
        for (int idx = 0; idx < length; ++idx) {
            if (idx > 0) {
                result.append(DELIMITER);
            }
            Object item = collectionArray[idx];
            result.append(LogMessageUtil.objToString(item, false));
        }
        if (!isTop) {
            result.append("]");
        }
        return result.toString();
    }

    private static String mapToString(Map<?, ?> map, boolean isTop) {
        if (map == null) {
            return STR_NULL;
        }
        Object[] keyset = map.keySet().toArray();
        int length = keyset.length;
        StringBuilder result = !isTop ? new StringBuilder("{") : new StringBuilder();
        for (int idx = 0; idx < length; ++idx) {
            Object key;
            Object item;
            if (idx > 0) {
                result.append(DELIMITER);
            }
            if ((item = map.get(key = keyset[idx])) == null) {
                result.append(key + "=" + STR_NULL);
                continue;
            }
            if (item.toString().isEmpty()) {
                result.append(key + "=" + STR_EMPTY);
                continue;
            }
            result.append(key + "=" + LogMessageUtil.objToString(item, false));
        }
        if (!isTop) {
            result.append("}");
        }
        return result.toString();
    }

    private static String arrayToString(Object array, boolean isTop) {
        if (array == null) {
            return STR_NULL;
        }
        int length = Array.getLength(array);
        StringBuilder result = !isTop ? new StringBuilder("[") : new StringBuilder();
        for (int idx = 0; idx < length; ++idx) {
            if (idx > 0) {
                result.append(DELIMITER);
            }
            Object item = Array.get(array, idx);
            result.append(LogMessageUtil.objToString(item, false));
        }
        if (!isTop) {
            result.append("]");
        }
        return result.toString();
    }

    private static String objToString(Object obj, boolean isTop) {
        if (obj == null) {
            return STR_NULL;
        }
        if (obj.toString().isEmpty()) {
            return STR_EMPTY;
        }
        if (obj.getClass().isArray()) {
            return LogMessageUtil.arrayToString(obj, isTop);
        }
        if (obj instanceof Collection) {
            return LogMessageUtil.collectionToString((Collection)obj, isTop);
        }
        if (obj instanceof Map) {
            return LogMessageUtil.mapToString((Map)obj, isTop);
        }
        return obj.toString();
    }

    private static final String crop(Object obj, int maxLength) {
        if (obj == null) {
            return STR_NULL;
        }
        String text = obj.toString();
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + STR_SKIP;
    }
}

