/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class CopyDirContents {
    private static byte[] buffer = new byte[0x100000];
    private static int files = 0;
    private static int dirs = 0;
    private static long bytes = 0L;
    private static long time = System.currentTimeMillis();
    private static int skipped = 0;

    public static void main(String[] a) throws IOException {
        File src = new File("/storage/BAK_EXT_DISK");
        File dest = new File("/media/WD Passport");
        CopyDirContents.copy(src, dest);
        System.out.println("Finished: ");
        CopyDirContents.printInfo();
    }

    private static void printInfo() {
        long now = System.currentTimeMillis();
        long duration = now - time;
        double throughtput = (double)bytes / (double)duration * 1000.0;
        double mbs = throughtput / 1024.0 / 1024.0;
        System.out.println("Copied dirs: " + dirs + ", files: " + files + ", bytes: " + bytes + " in " + duration + ", throughtput: " + throughtput + " bytes/second, " + mbs + " MB/s, skiped: " + skipped);
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            CopyDirContents.copyDir(src, dest);
        } else {
            CopyDirContents.copyFile(src, dest);
        }
    }

    private static void copyDir(File src, File dest) throws IOException {
        File[] ff;
        boolean res;
        ++dirs;
        if (!dest.exists() && !(res = dest.mkdir())) {
            throw new RuntimeException("Can't create directory " + dest.getAbsolutePath());
        }
        for (File f : ff = src.listFiles()) {
            CopyDirContents.copy(f, new File(dest.getAbsolutePath() + File.separatorChar + f.getName()));
        }
    }

    private static void copyFile(File src, File dest) throws IOException {
        if (++files / 1000 * 1000 == files) {
            CopyDirContents.printInfo();
        }
        if (dest.exists()) {
            if (++skipped / 1000 * 1000 == skipped) {
                CopyDirContents.printInfo();
            }
            return;
        }
        System.out.println("Copying file: " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        FileInputStream fIn = new FileInputStream(src);
        FileOutputStream fOut = new FileOutputStream(dest);
        CopyDirContents.copy(fIn, fOut);
        try {
            fIn.close();
        }
        catch (IOException ignored) {
            System.out.println("Ignored exception: " + ignored.getMessage());
        }
        try {
            fOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Couldn't copy " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
    }

    private static void copy(FileInputStream src, FileOutputStream dest) throws IOException {
        while (src.available() > 0) {
            int bytesToCopy = src.available() < buffer.length ? src.available() : buffer.length;
            int copied = src.read(buffer);
            dest.write(buffer, 0, copied);
            bytes += (long)copied;
        }
    }
}

