/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.IOUtils;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.StringUtils;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;

public class HistoDiffReader {
    public static void main(String[] a) throws Exception {
        String newP = "/Users/another/Documents/Projects/AYN/CRASH/2013-02-05/histo3.txt";
        String oldP = "/Users/another/Documents/Projects/AYN/CRASH/2013-02-05/histo2.txt";
        HistoDiffReader.compare(oldP, newP);
    }

    public static final void compare(String oldPath, String newPath) throws Exception {
        Histogramm oldH = HistoDiffReader.readHistogram(oldPath);
        Histogramm newH = HistoDiffReader.readHistogram(newPath);
        int oldObjects = oldH.getNumberOfObjects();
        int newObjects = newH.getNumberOfObjects();
        long oldMemory = oldH.getAmountOfMemory();
        long newMemory = newH.getAmountOfMemory();
        System.out.println("Comparing " + oldPath + " with " + newPath);
        System.out.println("Number of objects increased by " + NumberUtils.getDotedNumber(newObjects - oldObjects));
        System.out.println("Usage of memory   increased by " + NumberUtils.getDotedNumber(newMemory - oldMemory));
        System.out.println("number of classes increased by " + NumberUtils.getDotedNumber(newH.getEntryCount() - oldH.getEntryCount()));
        List<HistogramEntry> newEntries = newH.getEntries();
        List<HistogramEntry> oldEntries = oldH.getEntries();
        ArrayList<String> classNames = new ArrayList<String>();
        HashMap<String, HistogramEntry> map = new HashMap<String, HistogramEntry>(newEntries.size());
        for (HistogramEntry entry : newEntries) {
            map.put(entry.getClassName(), entry);
            classNames.add(entry.getClassName());
        }
        for (HistogramEntry entry : oldEntries) {
            HistogramEntry ne = (HistogramEntry)map.get(entry.className);
            if (ne == null) {
                entry.negate();
                map.put(entry.getClassName(), entry);
                classNames.add(entry.getClassName());
                continue;
            }
            ne.reduceBy(entry);
        }
        int unchangedClassCount = 0;
        ArrayList keys = new ArrayList();
        keys.addAll(map.keySet());
        for (String key : keys) {
            HistogramEntry entry = (HistogramEntry)map.get(key);
            if (entry.getInstanceCount() == 0 && entry.getBytes() == 0L) {
                ++unchangedClassCount;
                map.remove(key);
            }
            if (entry.getInstanceCount() == 0 || entry.getBytes() != 0L) continue;
            System.out.println("SANITY CHECK FAILED ON " + entry);
        }
        System.out.println("Unchanged classes: " + unchangedClassCount);
        System.out.println("Changed classes: " + map.size());
        long sumPosMem = 0L;
        int sumPosInstance = 0;
        List result = new ArrayList();
        result.addAll(map.values());
        result = StaticQuickSorter.sort(result, (SortType)new HistogrammEntrySortType());
        for (HistogramEntry e : result) {
            System.out.println(e.toDetails());
            if (e.bytes > 0L) {
                sumPosMem += e.bytes;
            }
            if (e.instanceCount <= 0) continue;
            sumPosInstance += e.instanceCount;
        }
        System.out.println("Memory increased by " + NumberUtils.getDotedNumber(sumPosMem) + ", instance increased by " + NumberUtils.getDotedNumber(sumPosInstance));
    }

    public static final Histogramm readHistogram(String path) throws Exception {
        String[] tt;
        Histogramm h = new Histogramm(path);
        String content = IOUtils.readFileAtOnceAsString(path);
        for (String line : tt = StringUtils.tokenize(content, '\n')) {
            if (line == null || (line = line.trim()).equals("") || line.startsWith("num") || line.startsWith("Total") || line.startsWith("---")) continue;
            try {
                HistogramEntry entry = new HistogramEntry(line);
                h.addEntry(entry);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("FAILED " + line);
            }
        }
        return h;
    }

    static class HistogrammEntrySortType
    extends SortType {
        public static final int SORT_BY_MEMORY = 1;
        public static final int SORT_BY_COUNT = 2;

        public HistogrammEntrySortType() {
            super(1, false);
        }
    }

    public static class HistogramEntry
    implements IComparable {
        private String className;
        private int position;
        private long bytes;
        private int instanceCount;

        public int getInstanceCount() {
            return this.instanceCount;
        }

        public void negate() {
            this.bytes *= -1L;
            this.instanceCount *= -1;
        }

        public void reduceBy(HistogramEntry anotherEntry) {
            this.bytes -= anotherEntry.bytes;
            this.instanceCount -= anotherEntry.instanceCount;
        }

        public void setInstanceCount(int instanceCount) {
            this.instanceCount = instanceCount;
        }

        public HistogramEntry(String line) {
            String[] t = StringUtils.tokenize(line, ' ');
            ArrayList<String> tt = new ArrayList<String>();
            tt.addAll(Arrays.asList(t));
            int index = -1;
            while ((index = tt.indexOf("")) != -1) {
                tt.remove(index);
            }
            this.position = Integer.parseInt(StringUtils.removeChar((String)tt.get(0), ':').trim());
            this.instanceCount = Integer.parseInt(((String)tt.get(1)).trim());
            this.bytes = Long.parseLong(((String)tt.get(2)).trim());
            this.className = ((String)tt.get(3)).trim();
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public long getBytes() {
            return this.bytes;
        }

        public void setBytes(int bytes) {
            this.bytes = bytes;
        }

        public String toString() {
            String ret = "";
            ret = ret + NumberUtils.itoa(this.position, 5);
            ret = ret + " ";
            ret = ret + NumberUtils.getDotedNumber(this.instanceCount);
            ret = ret + " ";
            ret = ret + NumberUtils.getDotedNumber(this.bytes);
            ret = ret + " ";
            ret = ret + this.className;
            return ret;
        }

        public String toDetails() {
            String ret = "";
            ret = ret + NumberUtils.itoa(this.position, 5);
            ret = ret + "\t";
            ret = ret + NumberUtils.getDotedNumber(this.instanceCount);
            ret = ret + "\t";
            ret = ret + NumberUtils.getDotedNumber(this.bytes);
            ret = ret + "\t";
            ret = ret + this.className;
            return ret;
        }

        public int compareTo(IComparable o, int method) {
            HistogramEntry anotherEntry = (HistogramEntry)o;
            switch (method) {
                case 2: {
                    return BasicComparable.compareInt(this.getInstanceCount(), anotherEntry.getInstanceCount());
                }
                case 1: {
                    return BasicComparable.compareLong(this.getBytes(), anotherEntry.getBytes());
                }
            }
            throw new AssertionError((Object)("Unknown method " + method));
        }
    }

    public static class Histogramm {
        private ArrayList<HistogramEntry> entries;
        private String name;

        public Histogramm(String aName) {
            this.name = aName;
            this.entries = new ArrayList();
        }

        public void addEntry(HistogramEntry toAdd) {
            this.entries.add(toAdd);
        }

        public String toString() {
            return this.name + " with " + this.entries.size() + " entries " + NumberUtils.getDotedNumber(this.getNumberOfObjects()) + " objects, " + NumberUtils.getDotedNumber(this.getAmountOfMemory()) + " bytes.";
        }

        public int getNumberOfObjects() {
            int ret = 0;
            for (HistogramEntry e : this.entries) {
                ret += e.instanceCount;
            }
            return ret;
        }

        public long getAmountOfMemory() {
            long ret = 0L;
            for (HistogramEntry e : this.entries) {
                ret += e.bytes;
            }
            return ret;
        }

        public int getEntryCount() {
            return this.entries.size();
        }

        public List<HistogramEntry> getEntries() {
            return this.entries;
        }
    }
}

