/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.crypt;

import BlowfishJ.BlowfishECB;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.StringUtils;
import net.anotheria.util.crypt.HexDecoder;

public class CryptTool {
    private final BlowfishECB cipher;
    private static final int NUMERATION_BASE_NUMBER = 13212358;

    public CryptTool(String key) {
        this(key.getBytes());
    }

    public CryptTool(byte[] key) {
        this.cipher = new BlowfishECB(key);
    }

    public byte[] encrypt(String toEncrypt) {
        byte[] toEncryptB;
        toEncrypt = CryptTool.padMod(toEncrypt, 8);
        try {
            toEncryptB = toEncrypt.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            toEncryptB = toEncrypt.getBytes();
        }
        this.cipher.encrypt(toEncryptB);
        return toEncryptB;
    }

    public String encryptToHex(String toEncrypt) {
        byte[] encrypted = this.encrypt(toEncrypt);
        return HexDecoder.toHexString(encrypted);
    }

    public byte[] decrypt(byte[] toDecrypt) {
        this.cipher.decrypt(toDecrypt);
        return toDecrypt;
    }

    public String decryptFromHex(String toDecrypt) {
        byte[] decrypted = this.decrypt(HexDecoder.fromHexString(toDecrypt));
        return new String(decrypted);
    }

    public String decryptFromHexTrim(String toDecrypt) {
        return this.decryptFromHex(toDecrypt).trim();
    }

    private static String padMod(String source, int length) {
        int adder = length - source.length() % length;
        if (adder == length) {
            return source;
        }
        StringBuilder ret = new StringBuilder(source);
        for (int i = 0; i < adder; ++i) {
            ret.append(' ');
        }
        return ret.toString();
    }

    public String encryptParameterMap(Map<String, String> parameters) {
        Iterator<String> keys = parameters.keySet().iterator();
        StringBuilder toEncode = new StringBuilder();
        while (keys.hasNext()) {
            if (toEncode.length() > 0) {
                toEncode.append('&');
            }
            String key = keys.next();
            String value = parameters.get(key);
            toEncode.append(key).append('=').append(value);
        }
        return this.encryptToHex(toEncode.toString().trim());
    }

    public Map<String, String> decryptParameterMap(String str) {
        String decrypted = this.decryptFromHex(str);
        decrypted = decrypted.trim();
        HashMap<String, String> map = new HashMap<String, String>();
        String[] tokens = StringUtils.tokenize(decrypted, '&');
        for (int i = 0; i < tokens.length; ++i) {
            String[] t = StringUtils.tokenize(tokens[i], '=');
            if (t.length == 2) {
                map.put(t[0], t[1]);
                continue;
            }
            map.put(t[0], "");
        }
        return map;
    }

    public static String idToChiffre(String id) {
        int normalizedId = Integer.parseInt(id) + 13212358;
        if (normalizedId > 99999999) {
            throw new AssertionError((Object)("Id[" + id + "] is to big for the current implementation"));
        }
        int lastDigit = normalizedId % 10;
        StringBuilder ret = new StringBuilder();
        String retIncrement = NumberUtils.itoa(normalizedId % 100);
        while (normalizedId > 0) {
            int n = normalizedId & 0x1F ^ lastDigit;
            normalizedId >>= 5;
            n = n <= 25 ? n + 65 : n + 24;
            ret.append((char)n);
        }
        ret.append(retIncrement);
        return ret.toString();
    }

    public static String chiffreToId(String chiffre) {
        StringBuilder toDenum = new StringBuilder(chiffre);
        int lastDigit = Character.getNumericValue(toDenum.charAt(toDenum.length() - 1));
        toDenum.delete(toDenum.length() - 2, toDenum.length());
        int ret = 0;
        int position = 0;
        for (char c : toDenum.toString().toCharArray()) {
            int n = (c >= 'A' ? c - 65 : c - 24) ^ lastDigit;
            ret += (n <<= 5 * position++);
        }
        return (ret -= 13212358) + "";
    }

    public void encryptBuffer(byte[] buffer) {
        if (buffer.length % 8 != 0) {
            throw new IllegalArgumentException("Buffer size is not alligned to 8-bytes boundary");
        }
        this.cipher.encrypt(buffer);
    }

    public void decryptBuffer(byte[] buffer) {
        if (buffer.length % 8 != 0) {
            throw new IllegalArgumentException("Buffer size is not alligned to 8-bytes boundary");
        }
        this.cipher.decrypt(buffer);
    }
}

