/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.content.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.util.StringUtils;
import net.anotheria.util.content.element.ContentElement;
import net.anotheria.util.content.element.DynamicElement;
import net.anotheria.util.content.element.StaticElement;
import net.anotheria.util.content.template.TemplateProcessor;
import net.anotheria.util.content.template.TemplateReplacementContext;
import net.anotheria.util.content.template.processors.ConditionTemplateProcessor;
import net.anotheria.util.content.template.processors.ConstantsTemplateProcessor;

public final class TemplateUtility {
    private static final Map<String, TemplateProcessor> defaultProcessors = new HashMap<String, TemplateProcessor>();

    private TemplateUtility() {
    }

    public static void addProcessor(String prefix, TemplateProcessor processor) {
        defaultProcessors.put(prefix, processor);
    }

    public static Map<String, TemplateProcessor> getDefaultProcessors() {
        HashMap<String, TemplateProcessor> ret = new HashMap<String, TemplateProcessor>();
        ret.putAll(defaultProcessors);
        return ret;
    }

    public static String replaceVariables(TemplateReplacementContext context, String src) {
        if (defaultProcessors.isEmpty()) {
            throw new RuntimeException("Processors are not configured");
        }
        return TemplateUtility.replaceVariables(context, src, defaultProcessors);
    }

    public static String replaceVariables(TemplateReplacementContext context, String src, Map<String, TemplateProcessor> processors) {
        if (src == null || src.length() == 0) {
            return src;
        }
        List<ContentElement> index = TemplateUtility.indexSource(src);
        return TemplateUtility.replaceVariables(context, index, processors);
    }

    private static String replaceVariables(TemplateReplacementContext context, List<ContentElement> index, Map<String, TemplateProcessor> processors) {
        StringBuilder ret = new StringBuilder();
        for (ContentElement el : index) {
            ret.append(TemplateUtility.replaceContentElement(context, el, processors));
        }
        return ret.toString();
    }

    private static List<ContentElement> indexSource(String src) {
        String myS = StringUtils.removeChar(src, '\r');
        List<String> stringIndex = StringUtils.indexSuperTags(myS, '{', '}');
        ArrayList<ContentElement> ret = new ArrayList<ContentElement>(stringIndex.size());
        for (String s : stringIndex) {
            ret.add(TemplateUtility.createContentElementInDynamic(s, '{', '}'));
        }
        return ret;
    }

    private static ContentElement createContentElementInDynamic(String elementText, char dynamicTagStart, char dynamicTagEnd) {
        if (elementText.charAt(0) != dynamicTagStart) {
            return new StaticElement(elementText);
        }
        String varName = StringUtils.strip(elementText, 1, 1);
        char c = varName.charAt(0);
        if (c == '\t' || c == ' ' || c == '\n' || c == '\r') {
            return new StaticElement(elementText);
        }
        if (varName != null && varName.startsWith("\"") && varName.endsWith("\"")) {
            return new StaticElement(StringUtils.strip(varName, 1, 1));
        }
        List<String> tokens = StringUtils.tokenize(varName, '{', '}', ':');
        if (tokens.size() < 2) {
            return new StaticElement("Wrong format \"" + varName + "\" expected: {prefix:varname[:default value]}");
        }
        String prefix = tokens.get(0);
        String var = tokens.get(1);
        String defaultValue = tokens.size() > 2 ? tokens.get(2) : "";
        List<ContentElement> varIndex = TemplateUtility.indexSource(var);
        List<ContentElement> defValueIndex = TemplateUtility.indexSource(defaultValue);
        return new DynamicElement(elementText, prefix, varIndex, defValueIndex);
    }

    private static String replaceContentElement(TemplateReplacementContext context, ContentElement contentElement, Map<String, TemplateProcessor> processors) {
        if (!contentElement.isDynamic()) {
            return contentElement.getElementText();
        }
        DynamicElement dynIndex = (DynamicElement)contentElement;
        String prefix = dynIndex.getPrefix();
        String var = TemplateUtility.replaceVariables(context, dynIndex.getVariableIndex(), processors);
        String defaultValue = TemplateUtility.replaceVariables(context, dynIndex.getDefValueIndex(), processors);
        TemplateProcessor processor = processors.get(prefix);
        if (processor == null) {
            return dynIndex.getElementText();
        }
        return processor.replace(prefix, var, defaultValue, context);
    }

    static {
        defaultProcessors.put("c", new ConstantsTemplateProcessor());
        ConditionTemplateProcessor p = new ConditionTemplateProcessor();
        defaultProcessors.put("if", p);
        defaultProcessors.put("ifNot", p);
        defaultProcessors.put("present", p);
        defaultProcessors.put("notPresent", p);
        defaultProcessors.put("equals", p);
        defaultProcessors.put("notEquals", p);
        defaultProcessors.put("inRange", p);
        defaultProcessors.put("greaterThan", p);
        defaultProcessors.put("greaterEqual", p);
        defaultProcessors.put("lessThan", p);
        defaultProcessors.put("lessEqual", p);
    }
}

