/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util.concurrency;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.util.concurrency.AbstractIdBasedLockManager;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;

public class SafeIdBasedLockManager<K>
extends AbstractIdBasedLockManager<K>
implements IdBasedLockManager<K> {
    private static final long serialVersionUID = -7086955847344168761L;
    private Map<K, IdBasedLock<K>> locks = new HashMap<K, IdBasedLock<K>>();

    @Override
    public synchronized IdBasedLock<K> obtainLock(K id) {
        IdBasedLock<K> lock = this.locks.get(id);
        if (lock != null) {
            lock.increaseRefCount();
            return lock;
        }
        lock = new IdBasedLock<K>(id, this);
        this.locks.put(id, lock);
        return lock;
    }

    @Override
    public synchronized void releaseLock(IdBasedLock<K> lock) {
        K id = lock.getId();
        if (lock.getRefCount().get() == 1) {
            this.locks.remove(id);
        }
        lock.decreaseRefCount();
    }

    @Override
    protected Map<K, IdBasedLock<K>> getLockMap() {
        return this.locks;
    }
}

