/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.anotheria.util.StringUtils;

public class UrlHelper {
    private String protocol;
    private String host;
    private int port = -1;
    private String path;
    private List<Parameter> params;
    private String reference;

    public UrlHelper() {
        this(null, null, -1, "", null);
    }

    public UrlHelper(URL url) {
        this(url.getProtocol(), url.getHost(), url.getPort(), url.getPath(), url.getRef());
        this.setQuery(url.getQuery());
    }

    public UrlHelper(String protocol, String host, int port, String path, String reference) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.reference = reference;
        this.params = new ArrayList<Parameter>();
    }

    public UrlHelper(String url) {
        int queryPos;
        int referencePos;
        this.params = new ArrayList<Parameter>();
        int protocolPos = url.indexOf("://");
        if (protocolPos > -1) {
            this.setProtocol(url.substring(0, protocolPos));
            url = url.substring(protocolPos + 3);
        }
        if ((referencePos = url.lastIndexOf(35)) > -1) {
            this.setReference(url.substring(referencePos + 1));
            url = url.substring(0, referencePos);
        }
        if ((queryPos = url.indexOf(63)) > -1) {
            this.setQuery(url.substring(queryPos));
            url = url.substring(0, queryPos);
        }
        int portPos = url.indexOf(58);
        int pathPos = url.indexOf(47, portPos);
        if (portPos > -1) {
            this.setHost(url.substring(0, portPos));
            if (pathPos > -1) {
                this.setPort(Integer.parseInt(url.substring(portPos + 1, pathPos)));
                this.setPath(url.substring(pathPos));
            } else {
                this.setPort(Integer.parseInt(url.substring(portPos + 1, url.length())));
            }
        } else if (pathPos > -1) {
            this.setHost(url.substring(0, pathPos));
            this.setPath(url.substring(pathPos));
        } else {
            this.setHost(url);
        }
    }

    public void setQuery(String query) {
        if (query != null) {
            if (query.startsWith("?") && query.length() > 1) {
                query = query.substring(1);
            }
            String[] params = StringUtils.tokenize(query, '&');
            for (int i = 0; i < params.length; ++i) {
                this.addParameter(params[i]);
            }
        }
    }

    public void addParameter(String paramName, String paramValue) {
        Parameter newParameter = new Parameter();
        newParameter.setName(paramName);
        newParameter.setValue(paramValue);
        if (paramValue != null && paramValue.length() > 0) {
            int i = this.params.indexOf(newParameter);
            if (i >= 0) {
                this.params.set(i, newParameter);
            } else {
                this.params.add(newParameter);
            }
        } else {
            this.params.remove(newParameter);
        }
    }

    public String getParameter(String paramName) {
        for (Parameter param : this.params) {
            if (!param.getName().equals(paramName)) continue;
            return param.getValue();
        }
        return null;
    }

    public void removeParameter(String paramName) {
        this.addParameter(paramName, null);
    }

    public void removeParameters() {
        this.params = new ArrayList<Parameter>();
    }

    public void addParameter(String paramString) {
        String[] nameValuePair = StringUtils.tokenize(paramString, '=');
        if (nameValuePair.length == 2) {
            this.addParameter(nameValuePair[0], nameValuePair[1]);
        } else if (nameValuePair.length == 1) {
            this.addParameter(paramString, "");
        } else {
            throw new RuntimeException("Parameter does not contain a name-value pair. (e.g. name=value)");
        }
    }

    public void addParameters(Map<String, String> parameters) {
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            String value = param.getValue();
            String key = param.getKey();
            if (value instanceof String[]) {
                this.addParameter(key, ((String[])value)[0]);
                continue;
            }
            this.addParameter(key, value.toString());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.protocol != null) {
            result.append(this.protocol);
            result.append("://");
        }
        if (this.host != null) {
            result.append(this.host);
        }
        if (this.port != -1 && this.port != 80) {
            result.append(":");
            result.append(this.port);
        }
        if (this.path != null) {
            result.append(this.path);
        }
        if (this.params.size() > 0) {
            result.append("?");
        }
        result.append(this.parametersToString());
        if (this.reference != null && this.reference.length() > 0) {
            result.append("#");
            result.append(this.reference);
        }
        return result.toString();
    }

    public String parametersToString() {
        StringBuilder result = new StringBuilder();
        Iterator<Parameter> allParams = this.params.iterator();
        while (allParams.hasNext()) {
            Parameter param = allParams.next();
            result.append(param.getName());
            result.append("=");
            try {
                result.append(URLEncoder.encode(param.getValue(), "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (!allParams.hasNext()) continue;
            result.append("&");
        }
        return result.toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getQuery() {
        StringBuilder result = new StringBuilder();
        Iterator<Parameter> allParams = this.params.iterator();
        while (allParams.hasNext()) {
            Parameter param = allParams.next();
            result.append(param.getName());
            result.append("=");
            try {
                result.append(URLEncoder.encode(param.getValue(), "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (!allParams.hasNext()) continue;
            result.append("&");
        }
        return result.toString();
    }

    public class Parameter {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            return o instanceof Parameter && this.name.equals(((Parameter)o).getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

