/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.util.ArrayList;
import java.util.List;

public class StringPattern {
    public static final char DEFAULT_WILDCARD = '*';
    private char wildCard;
    private String equals;
    private String startsWith;
    private String endsWith;
    private List<String> indexof;

    public StringPattern(String pattern) {
        this(pattern, '*');
    }

    public StringPattern(String pattern, char wildCard) {
        this.wildCard = wildCard;
        List<Integer> wildCards = this.searchWildcards(pattern);
        if (wildCards.size() == 0) {
            this.equals = pattern;
            return;
        }
        if (wildCards.get(0) > 0) {
            this.startsWith = pattern.substring(0, wildCards.get(0));
        }
        if (wildCards.get(wildCards.size() - 1) < pattern.length() - 1) {
            this.endsWith = pattern.substring(wildCards.get(wildCards.size() - 1) + 1);
        }
        if (wildCards.size() == 1) {
            return;
        }
        this.indexof = new ArrayList<String>();
        for (int i = 0; i < wildCards.size() - 1; ++i) {
            int start = wildCards.get(i);
            int end = wildCards.get(i + 1);
            this.indexof.add(pattern.substring(start + 1, end));
        }
    }

    private List<Integer> searchWildcards(String pattern) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) != this.wildCard) continue;
            result.add(i);
        }
        return result;
    }

    public boolean match(String aString) {
        return this.match(aString, new ArrayList<String>());
    }

    public boolean match(String aString, List<String> matches) {
        if (this.equals != null) {
            return aString.equals(this.equals);
        }
        int leftMatch = 0;
        int rightMatch = aString.length();
        if (this.startsWith != null) {
            if (aString.startsWith(this.startsWith)) {
                leftMatch = this.startsWith.length();
            } else {
                return false;
            }
        }
        if (this.endsWith != null) {
            if (aString.endsWith(this.endsWith)) {
                rightMatch = aString.length() - this.endsWith.length();
            } else {
                return false;
            }
        }
        if (this.indexof != null) {
            int lastIndex = 0;
            for (String io : this.indexof) {
                int index = aString.indexOf(io, lastIndex);
                if (index == -1) {
                    return false;
                }
                if (matches != null) {
                    matches.add(aString.substring(leftMatch, index));
                    leftMatch = index + io.length();
                }
                lastIndex = index;
            }
        }
        matches.add(aString.substring(leftMatch, rightMatch));
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.equals != null) {
            result.append("equals=" + this.equals);
        }
        if (this.startsWith != null) {
            result.append(", startsWith=" + this.startsWith);
        }
        if (this.indexof != null) {
            for (String io : this.indexof) {
                result.append(", indexof=" + io);
            }
        }
        if (this.endsWith != null) {
            result.append(", endsWith=" + this.endsWith);
        }
        return result.toString();
    }
}

