/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.apache.log4j.Logger;

public final class PidTools {
    static final Logger log = Logger.getLogger(PidTools.class);

    private PidTools() {
    }

    public static final int getPid() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (processName == null) {
            return -1;
        }
        int indexOfAtt = processName.indexOf(64);
        if (indexOfAtt == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(processName.substring(0, indexOfAtt));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logPid() {
        int pid = PidTools.getPid();
        if (pid <= 0) {
            return;
        }
        String pidFile = System.getProperty("pidfile");
        if (pidFile == null) {
            pidFile = "logs/pid";
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(pidFile));
            out.write(pid + "");
            out.flush();
        }
        catch (IOException e) {
            log.error((Object)("Could not write PID " + pid + " into file " + pidFile + ": " + e), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("My PID: " + PidTools.getPid());
    }
}

