/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.sorter.DummySortType;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;

public class NameAnalyzer {
    private static long dirFound;
    private static long filesFound;
    private static long javaFilesFound;
    private static Set<String> names;
    private static HashMap<String, ElementCount> elements;

    public static void main(String[] a) throws IOException {
        NameAnalyzer.proceed(new File("."));
        System.out.println("Finished found files: " + filesFound + ", dirs: " + dirFound + ", java files: " + javaFilesFound);
        System.out.println("Found " + names.size() + " names, " + elements.size() + " elements.");
        List list = new ArrayList<ElementCount>();
        list.addAll(elements.values());
        list = StaticQuickSorter.sort(list, (SortType)new DummySortType());
        for (ElementCount ec : list) {
            System.out.println(ec);
        }
    }

    private static void proceed(File f) {
        ++filesFound;
        if (f.isDirectory()) {
            NameAnalyzer.proceedDirectory(f);
        } else {
            NameAnalyzer.proceedFile(f);
        }
    }

    private static void proceedFile(File f) {
        String name = f.getName();
        if (!name.endsWith(".java")) {
            return;
        }
        ++javaFilesFound;
        if (!names.add(name = name.substring(0, name.length() - ".java".length()))) {
            System.out.println("Double name: " + name);
        }
        List<String> listOfElements = NameAnalyzer.uncamelCase(name);
        for (String s : listOfElements) {
            ElementCount ec = elements.get(s);
            if (ec == null) {
                ec = new ElementCount(s);
                elements.put(s, ec);
            }
            ec.increase();
        }
    }

    private static void proceedDirectory(File f) {
        File[] files;
        ++dirFound;
        for (File afile : files = f.listFiles()) {
            NameAnalyzer.proceed(afile);
        }
    }

    private static void test() {
        System.out.println("FactoryUtil -> " + NameAnalyzer.uncamelCase("FactoryUtil"));
        System.out.println("PersonalDataController -> " + NameAnalyzer.uncamelCase("PersonalDataController"));
        System.out.println("MatchingDAOFactory -> " + NameAnalyzer.uncamelCase("MatchingDAOFactory"));
    }

    private static List<String> uncamelCase1(String s) {
        ArrayList<String> list = new ArrayList<String>();
        boolean inCamelCase = false;
        boolean previousCamelCase = false;
        String current = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!inCamelCase && Character.isUpperCase(c)) {
                if (current.length() > 0 && !previousCamelCase) {
                    list.add(current);
                }
                current = "" + c;
                previousCamelCase = true;
                continue;
            }
            current = current + c;
            previousCamelCase = false;
        }
        if (current != null && current.length() > 0) {
            list.add(current);
        }
        return list;
    }

    private static List<String> uncamelCase2(String s) {
        ArrayList<String> list = new ArrayList<String>();
        boolean inCamelCase = false;
        boolean previousCamelCase = false;
        String current = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                current = current + c;
                inCamelCase = true;
                continue;
            }
            inCamelCase = false;
            if (current.length() > 1) {
                list.add(current);
            }
            current = "";
        }
        if (current != null && current.length() > 0) {
            list.add(current);
        }
        return list;
    }

    private static List<String> uncamelCase(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(NameAnalyzer.uncamelCase1(s));
        ret.addAll(NameAnalyzer.uncamelCase2(s));
        return ret;
    }

    static {
        names = new HashSet<String>();
        elements = new HashMap();
    }

    public static class ElementCount
    implements IComparable {
        String name;
        int count;

        public ElementCount(String aName) {
            this.name = aName;
            this.count = 0;
        }

        public int compareTo(IComparable anotherObject, int method) {
            return BasicComparable.compareLong(this.count, ((ElementCount)anotherObject).count);
        }

        public void increase() {
            ++this.count;
        }

        public String toString() {
            return this.name + " = " + this.count;
        }
    }
}

