/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionTimer {
    private Map<String, TimerEntry> timers;
    private AtomicInteger nextID = new AtomicInteger(0);
    private String name;

    public ExecutionTimer(String aName) {
        this.timers = new ConcurrentHashMap<String, TimerEntry>();
        this.name = aName;
    }

    public ExecutionTimer() {
        this("timer");
    }

    public void startExecution(String aKey) {
        TimerEntry entry = new TimerEntry(aKey);
        this.timers.put(aKey, entry);
    }

    public void continueExecution(String aKey) {
        try {
            TimerEntry entry = this.getTimerEntry(aKey);
            entry.continueExecution();
        }
        catch (Exception e) {
            this.startExecution(aKey);
        }
    }

    public void stopExecution(String aKey) {
        this.getTimerEntry(aKey).stop();
    }

    public long getExecutionTime(String aKey) {
        return this.getTimerEntry(aKey).getTime();
    }

    public long getTotalExecutionTime() {
        Collection<TimerEntry> entries = this.timers.values();
        long sum = 0L;
        for (TimerEntry entry : entries) {
            sum += entry.getTime();
        }
        return sum;
    }

    public List<TimerEntry> getExecutionTimerEntriesOrderedByKeys() {
        return this.sortEntries(this.getTimerEntries(), Method.KEY);
    }

    public List<TimerEntry> getExecutionTimerEntriesOrderedByCreation() {
        return this.sortEntries(this.getTimerEntries(), Method.CREATION);
    }

    public List<TimerEntry> getExecutionTimerEntriesOrderedByTime() {
        return this.sortEntries(this.getTimerEntries(), Method.TIME);
    }

    public void printExecutionTimesOrderedByTime() {
        this.printExecutionTimes(Method.TIME);
    }

    public void printExecutionTimesOrderedByKeys() {
        this.printExecutionTimes(Method.KEY);
    }

    public void printExecutionTimesOrderedByCreation() {
        this.printExecutionTimes(Method.CREATION);
    }

    private void printExecutionTimes(Method method) {
        List<TimerEntry> v = this.sortEntries(this.getTimerEntries(), method);
        System.out.println("============= " + this.name + " =============");
        for (int i = 0; i < v.size(); ++i) {
            System.out.println(v.get(i).toString(method));
        }
        System.out.print("=============");
        for (int t = 0; t < this.name.length() + 2; ++t) {
            System.out.print("=");
        }
        System.out.println("=============");
    }

    private List<TimerEntry> sortEntries(List<TimerEntry> aSrc, Method aMethod) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < aSrc.size() - 1; ++i) {
                TimerEntry second;
                TimerEntry first = aSrc.get(i);
                int result = this.compare(first, second = aSrc.get(i + 1), aMethod);
                if (result <= 0) continue;
                changed = true;
                aSrc.set(i, second);
                aSrc.set(i + 1, first);
            }
        }
        return aSrc;
    }

    private int compare(TimerEntry aFirst, TimerEntry aSecond, Method aMethod) {
        switch (aMethod) {
            case CREATION: {
                return aFirst.id < aSecond.id ? -1 : (aFirst.id > aSecond.id ? 1 : 0);
            }
            case TIME: {
                long time1 = aFirst.getTime();
                long time2 = aSecond.getTime();
                return time1 < time2 ? -1 : (time1 > time2 ? 1 : 0);
            }
        }
        return aFirst.key.compareToIgnoreCase(aSecond.key);
    }

    private List<TimerEntry> getTimerEntries() {
        ArrayList<TimerEntry> ret = new ArrayList<TimerEntry>();
        ret.addAll(this.timers.values());
        return ret;
    }

    private TimerEntry getTimerEntry(String aKey) {
        TimerEntry entry = this.timers.get(aKey);
        if (entry == null) {
            throw new RuntimeException("No such key:\"" + aKey + "\"");
        }
        return entry;
    }

    private class TimerEntry {
        private long startTime;
        private long endTime;
        private long previousTime;
        private int id;
        private String key;

        TimerEntry(String aKey) {
            this.key = aKey;
            this.id = ExecutionTimer.this.nextID.incrementAndGet();
            this.start();
            this.previousTime = 0L;
        }

        protected void start() {
            this.startTime = System.currentTimeMillis();
        }

        protected void stop() {
            this.endTime = System.currentTimeMillis();
        }

        protected void continueExecution() {
            this.previousTime += this.endTime - this.startTime;
            this.start();
        }

        public long getTime() {
            return this.endTime - this.startTime + this.previousTime;
        }

        public String getKey() {
            return this.key;
        }

        public int getCreationID() {
            return this.id;
        }

        public String toString(Method aMethod) {
            switch (aMethod) {
                case CREATION: {
                    return this.toStringCreation();
                }
            }
            return this.toStringKey();
        }

        private String toStringCreation() {
            return this.id + "\t" + this.key + "\t" + this.getTime();
        }

        private String toStringKey() {
            return this.key + "\t" + this.getTime();
        }

        public String toString() {
            return this.toStringKey();
        }
    }

    private static enum Method {
        KEY,
        TIME,
        CREATION;

    }
}

