/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.util.GregorianCalendar;
import net.anotheria.util.Date;
import net.anotheria.util.TimeUnit;

public final class DateUtility {
    public static boolean isAfterNow(Date d) {
        return DateUtility.isAfter(d, new Date(System.currentTimeMillis()));
    }

    public static boolean isAfter(Date d1, Date d2) {
        if (d1.year < d2.year) {
            return false;
        }
        if (d1.year > d2.year) {
            return true;
        }
        if (d1.month < d2.month) {
            return false;
        }
        if (d1.month > d2.month) {
            return true;
        }
        if (d1.day < d2.day) {
            return false;
        }
        if (d1.day > d2.day) {
            return true;
        }
        if (d1.hour != -1 && d1.min != -1 && d2.hour != -1 && d2.min != -1) {
            if (d1.hour < d2.hour) {
                return false;
            }
            if (d1.hour > d2.hour) {
                return true;
            }
            if (d1.min < d2.min) {
                return false;
            }
            if (d1.min > d2.min) {
                return true;
            }
        }
        return false;
    }

    public static boolean isBeforeNow(Date d) {
        return DateUtility.isBefore(d, new Date(System.currentTimeMillis()));
    }

    public static boolean isBefore(Date d1, Date d2) {
        return DateUtility.isAfter(d2, d1);
    }

    public static boolean isToday(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Invalid incoming parameter date");
        }
        Date currentDate = new Date(System.currentTimeMillis());
        return date.getYear() == currentDate.getYear() && date.getMonth() == currentDate.getMonth() && date.getDay() == currentDate.getDay();
    }

    public static boolean isSame(Date d1, Date d2) {
        return !DateUtility.isAfter(d2, d1) && !DateUtility.isBefore(d2, d1);
    }

    public static Date nextDate(Date d) {
        int month;
        Date nextDate;
        if (!Date.isValid(d)) {
            return null;
        }
        int day = d.day;
        if (!Date.isValid(nextDate = new Date(++day, d.month, d.year)) && !Date.isValid(nextDate = new Date(1, month = d.month + 1, d.year))) {
            int year = d.year + 1;
            nextDate = new Date(1, 1, year);
        }
        return nextDate;
    }

    public static Date previousDate(Date d) {
        int month;
        Date prevDate;
        if (!Date.isValid(d)) {
            return null;
        }
        int day = d.day;
        if (!Date.isValid(prevDate = new Date(--day, d.month, d.year)) && !Date.isValid(prevDate = new Date(Date.DAY_OF_MONTH[month = d.month - 1], month, d.year))) {
            int year = d.year - 1;
            prevDate = new Date(31, 12, year);
        }
        return prevDate;
    }

    public static GregorianCalendar toLocalTime(GregorianCalendar date) {
        GregorianCalendar calLOC = new GregorianCalendar();
        GregorianCalendar calSRC = new GregorianCalendar(date.getTimeZone());
        int offset = -(calLOC.get(11) - calSRC.get(11)) * 60 * 60 * 1000;
        calSRC.set(15, offset);
        calSRC.setTimeZone(calLOC.getTimeZone());
        date.set(15, offset);
        return date;
    }

    public static String toDateOnly(Date d) {
        String ret = "";
        ret = ret + (d.day < 10 ? "0" + d.day : "" + d.day) + ".";
        ret = ret + (d.month < 10 ? "0" + d.month : "" + d.month) + ".";
        ret = ret + d.year;
        return ret;
    }

    public static String toDayAndMonthOnly(Date d) {
        String ret = "";
        ret = ret + (d.day < 10 ? "0" + d.day : "" + d.day) + ".";
        ret = ret + (d.month < 10 ? "0" + d.month : "" + d.month) + ".";
        return ret;
    }

    public static String toTimeOnly(Date d) {
        return (d.hour < 10 ? "0" + d.hour : "" + d.hour) + ":" + (d.min < 10 ? "0" + d.min : "" + d.min);
    }

    public static String dynamicString(Date date) {
        int year = date.year;
        int hour = date.hour;
        int min = date.min;
        int day = date.day;
        int month = date.month;
        if (!(min != -1 && min != 0 || hour != -1 && hour != 0)) {
            if (year == 0) {
                if (month == 0 || day == 0) {
                    return null;
                }
                return "" + (date.day < 10 ? "0" + date.day : "" + date.day) + "." + (date.month < 10 ? "0" + date.month : "" + date.month);
            }
            return DateUtility.toDateOnly(date);
        }
        if (year == 0) {
            if (month == 0 || day == 0) {
                return DateUtility.toTimeOnly(date);
            }
            return "" + (date.day < 10 ? "0" + date.day : "" + date.day) + "." + (date.month < 10 ? "0" + date.month : "" + date.month) + ", " + DateUtility.toTimeOnly(date);
        }
        return DateUtility.toDateOnly(date) + ", " + DateUtility.toTimeOnly(date);
    }

    public static Date nextWeek(Date d) {
        Date d2 = new Date(d.toMill() + 604800000L);
        return d2;
    }

    public static int getCalendarWeekForDate(Date date) {
        Date startOfFirstWeek = new Date(4, 1, date.year);
        int cal = 1;
        Date startOfThisWeek = date;
        while (!startOfThisWeek.wDay.equals("Mo.")) {
            startOfThisWeek = DateUtility.previousDate(startOfThisWeek);
        }
        if (!startOfThisWeek.equals(date)) {
            return DateUtility.getCalendarWeekForDate(startOfThisWeek);
        }
        while (!startOfFirstWeek.wDay.equals("Mo.")) {
            startOfFirstWeek = DateUtility.previousDate(startOfFirstWeek);
        }
        if (date.month == 1 && startOfThisWeek.month == 12 && date.day == 1 && (date.wDay.equals("So.") || date.wDay.equals("Sa.") || date.wDay.equals("Fr."))) {
            return DateUtility.getCalendarWeekForDate(startOfThisWeek);
        }
        while (DateUtility.isBefore(startOfFirstWeek, date)) {
            startOfFirstWeek = DateUtility.nextWeek(startOfFirstWeek);
            startOfFirstWeek.hour = 0;
            ++cal;
            if (!DateUtility.isBefore(date, startOfFirstWeek)) continue;
            --cal;
        }
        return cal;
    }

    public static Date getFirstDayOfWeek(int week, int year) {
        Date d = new Date(4, 1, year);
        while (!d.wDay.equals("Mo.")) {
            d = DateUtility.previousDate(d);
        }
        for (int kw = 1; kw < week; ++kw) {
            d = DateUtility.nextDate(DateUtility.nextDate(DateUtility.nextDate(DateUtility.nextDate(DateUtility.nextDate(DateUtility.nextDate(DateUtility.nextDate(d)))))));
        }
        return d;
    }

    public static int getAge(long fromDate) {
        return DateUtility.getAge(fromDate, System.currentTimeMillis());
    }

    public static int getAge(Date fromDate) {
        return DateUtility.getAge(fromDate, new Date(System.currentTimeMillis()));
    }

    public static int getAge(long fromDate, long toDate) {
        Date _fromDate = new Date(fromDate);
        Date _toDate = new Date(toDate);
        return DateUtility.getAge(_fromDate, _toDate);
    }

    public static int getAge(Date fromDate, Date toDate) {
        int age = toDate.getYear() - fromDate.getYear();
        int monthDiff = toDate.getMonth() - fromDate.getMonth();
        if (monthDiff > 0) {
            return age;
        }
        if (monthDiff < 0) {
            return --age;
        }
        int daysDiff = toDate.getDay() - fromDate.getDay();
        if (daysDiff > 0) {
            return age;
        }
        if (daysDiff < 0) {
            return --age;
        }
        return age > 0 ? age : 0;
    }

    public static int getDays(Date fromDate) {
        return DateUtility.getDays(fromDate.toMill());
    }

    public static int getDays(long fromDate) {
        return DateUtility.getDays(fromDate, System.currentTimeMillis());
    }

    public static int getDays(Date fromDate, Date toDate) {
        return DateUtility.getDays(fromDate.toMill(), toDate.toMill());
    }

    public static int getDays(long fromDate, long toDate) {
        return (int)((toDate - fromDate) / TimeUnit.DAY.getMillis());
    }

    public static long getHourBeginning() {
        return DateUtility.getHourBeginning(System.currentTimeMillis());
    }

    public static long getHourBeginning(long date) {
        Date d = new Date(date);
        return new Date(d.getDay(), d.getMonth(), d.getYear(), d.getHour(), 0).toMill();
    }

    public static long getNextHourBeginning() {
        return DateUtility.getHourBeginning() + TimeUnit.HOUR.getMillis();
    }

    public static long getNextHourBeginning(long date) {
        return DateUtility.getHourBeginning(date) + TimeUnit.HOUR.getMillis();
    }

    public static long getDayBeginning(long date) {
        Date d = new Date(date);
        return new Date(d.getDay(), d.getMonth(), d.getYear(), 0, 0).toMill();
    }

    public static long getDayEnding(long date) {
        return DateUtility.getDayBeginning(date) + TimeUnit.DAY.getMillis() - 1L;
    }

    private DateUtility() {
    }
}

