/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.anotheria.util.StringUtils;

public class CharacterEntityCoder {
    private static final Hashtable<Character, String> ENTITIES = new Hashtable();
    private static final Vector<String[]> HTML_ENTITIES;
    private static final Hashtable<String, String> HTML_2_XML_ENTITIES;

    public static final String encodeString(String s) {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < s.length(); ++i) {
            Character c = new Character(s.charAt(i));
            String temp = ENTITIES.get(c);
            result.append(temp == null ? "" + s.charAt(i) : temp);
        }
        return result.toString();
    }

    public static final String htmlEncodeString(String s) {
        for (int i = 0; i < HTML_ENTITIES.size(); ++i) {
            String[] sa = HTML_ENTITIES.elementAt(i);
            char o = sa[0].charAt(0);
            String n = sa[1];
            s = StringUtils.replace(s, o, n);
        }
        return s;
    }

    public static final String decodeString(String s) {
        Enumeration<Character> e = ENTITIES.keys();
        while (e.hasMoreElements()) {
            Character o = e.nextElement();
            String n = ENTITIES.get(o);
            int j = n.length();
            String s1 = "";
            int lastI = 0;
            for (int i = 0; i < s.length() - j; ++i) {
                if (!s.substring(i, i + j).equals(n)) continue;
                s1 = s1 + s.substring(lastI, i) + o;
                i = lastI = i + j;
            }
            if (s1.equals("")) continue;
            s = s1;
        }
        return s;
    }

    public static final String decodeHtmlString(String s) {
        for (int k = 0; k < HTML_ENTITIES.size(); ++k) {
            String[] sa = HTML_ENTITIES.elementAt(k);
            char o = sa[0].charAt(0);
            String n = sa[1];
            int j = n.length();
            String s1 = "";
            int lastI = 0;
            for (int i = 0; i < s.length() - j; ++i) {
                if (!s.substring(i, i + j).equals(n)) continue;
                s1 = s1 + s.substring(lastI, i) + o;
                i = lastI = i + j;
            }
            if (s1.equals("")) continue;
            s = s1;
        }
        return s;
    }

    public static final String htm2xml(String s) {
        Enumeration<String> e = HTML_2_XML_ENTITIES.keys();
        while (e.hasMoreElements()) {
            String htmString = e.nextElement();
            String xmlString = HTML_2_XML_ENTITIES.get(htmString);
            int j = htmString.length();
            int lastI = 0;
            String replaced = "";
            for (int i = 0; i < s.length() - j; ++i) {
                if (!s.substring(i, i + j).equals(htmString)) continue;
                replaced = replaced + s.substring(lastI, i) + xmlString;
                lastI = i + j;
                i = lastI - 1;
            }
            if ((replaced = replaced + s.substring(lastI, s.length())).equals("")) continue;
            s = replaced;
        }
        return s;
    }

    static {
        ENTITIES.put(new Character('\n'), "&#010;");
        ENTITIES.put(new Character('\r'), "&#013;");
        ENTITIES.put(new Character('\t'), "&#009;");
        ENTITIES.put(new Character('&'), "&#038;");
        ENTITIES.put(new Character('\"'), "&#034;");
        ENTITIES.put(new Character('\u00df'), "&#167;");
        ENTITIES.put(new Character('\ufb02'), "&#223;");
        ENTITIES.put(new Character('<'), "&#060;");
        ENTITIES.put(new Character('>'), "&#062;");
        ENTITIES.put(new Character('\u00c4'), "&#198;");
        ENTITIES.put(new Character('\u00bf'), "&#192;");
        ENTITIES.put(new Character('\u00a1'), "&#193;");
        ENTITIES.put(new Character('\u00ac'), "&#194;");
        ENTITIES.put(new Character('\u221a'), "&#195;");
        ENTITIES.put(new Character('\u0192'), "&#196;");
        ENTITIES.put(new Character('\u2248'), "&#197;");
        ENTITIES.put(new Character('\u2206'), "&#198;");
        ENTITIES.put(new Character('\u00ab'), "&#199;");
        ENTITIES.put(new Character('\u00bb'), "&#200;");
        ENTITIES.put(new Character('\u2026'), "&#201;");
        ENTITIES.put(new Character('\u00a0'), "&#202;");
        ENTITIES.put(new Character('\u00c0'), "&#203;");
        ENTITIES.put(new Character('\u00c3'), "&#204;");
        ENTITIES.put(new Character('\u00d5'), "&#205;");
        ENTITIES.put(new Character('\u0152'), "&#206;");
        ENTITIES.put(new Character('\u0153'), "&#207;");
        ENTITIES.put(new Character('\u2014'), "&#209;");
        ENTITIES.put(new Character('\u201c'), "&#210;");
        ENTITIES.put(new Character('\u201d'), "&#211;");
        ENTITIES.put(new Character('\u2018'), "&#212;");
        ENTITIES.put(new Character('\u2019'), "&#213;");
        ENTITIES.put(new Character('\u00f7'), "&#214;");
        ENTITIES.put(new Character('\u0178'), "&#217;");
        ENTITIES.put(new Character('\u2044'), "&#218;");
        ENTITIES.put(new Character('\u20ac'), "&#219;");
        ENTITIES.put(new Character('\u2039'), "&#220;");
        ENTITIES.put(new Character('\u203a'), "&#221;");
        ENTITIES.put(new Character('\u2021'), "&#224;");
        ENTITIES.put(new Character('\u00b7'), "&#225;");
        ENTITIES.put(new Character('\u201a'), "&#226;");
        ENTITIES.put(new Character('\u201e'), "&#227;");
        ENTITIES.put(new Character('\u2030'), "&#228;");
        ENTITIES.put(new Character('\u00ca'), "&#230;");
        ENTITIES.put(new Character('\u00c1'), "&#231;");
        ENTITIES.put(new Character('\u00cb'), "&#232;");
        ENTITIES.put(new Character('\u00c8'), "&#233;");
        ENTITIES.put(new Character('\u00cd'), "&#234;");
        ENTITIES.put(new Character('\u00ce'), "&#235;");
        ENTITIES.put(new Character('\u00cf'), "&#236;");
        ENTITIES.put(new Character('\u00cc'), "&#237;");
        ENTITIES.put(new Character('\u00d3'), "&#238;");
        ENTITIES.put(new Character('\u00d4'), "&#239;");
        ENTITIES.put(new Character('\uf8ff'), "&#240;");
        ENTITIES.put(new Character('\u00d2'), "&#241;");
        ENTITIES.put(new Character('\u00da'), "&#242;");
        ENTITIES.put(new Character('\u00db'), "&#243;");
        ENTITIES.put(new Character('\u00d9'), "&#244;");
        ENTITIES.put(new Character('\u0131'), "&#245;");
        ENTITIES.put(new Character('\u02c6'), "&#246;");
        ENTITIES.put(new Character('\u02d8'), "&#249;");
        ENTITIES.put(new Character('\u02d9'), "&#250;");
        ENTITIES.put(new Character('\u02da'), "&#251;");
        ENTITIES.put(new Character('\u00b8'), "&#252;");
        ENTITIES.put(new Character('\u02dd'), "&#253;");
        ENTITIES.put(new Character('\u02c7'), "&#255;");
        ENTITIES.put(new Character('-'), "&#8212;");
        HTML_ENTITIES = new Vector();
        HTML_ENTITIES.addElement(new String[]{"&", "&amp;"});
        HTML_ENTITIES.addElement(new String[]{"\"", "&quot;"});
        HTML_ENTITIES.addElement(new String[]{"\u00df", "&sect;"});
        HTML_ENTITIES.addElement(new String[]{"\ufb02", "&szlig;"});
        HTML_ENTITIES.addElement(new String[]{"<", "&lt;"});
        HTML_ENTITIES.addElement(new String[]{">", "&gt;"});
        HTML_ENTITIES.addElement(new String[]{"\u00c4", "&euro;"});
        HTML_ENTITIES.addElement(new String[]{"\u00bf", "&Agrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u00a1", "&Aacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u00ac", "&Acirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u221a", "&Atilde;"});
        HTML_ENTITIES.addElement(new String[]{"\u0192", "&Auml;"});
        HTML_ENTITIES.addElement(new String[]{"\u2248", "&Aring;"});
        HTML_ENTITIES.addElement(new String[]{"\u2206", "&AElig;"});
        HTML_ENTITIES.addElement(new String[]{"\u00ab", "&Ccedil;"});
        HTML_ENTITIES.addElement(new String[]{"\u00bb", "&Egrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u2026", "&Eacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u00a0", "&Ecirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u00c0", "&Euml;"});
        HTML_ENTITIES.addElement(new String[]{"\u00c3", "&Igrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u00d5", "&Iacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u0152", "&Icirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u0153", "&Iuml;"});
        HTML_ENTITIES.addElement(new String[]{"\u2014", "&Ntilde;"});
        HTML_ENTITIES.addElement(new String[]{"\u201c", "&Ograve;"});
        HTML_ENTITIES.addElement(new String[]{"\u201d", "&Oacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u2018", "&Ocirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u2019", "&Otilde;"});
        HTML_ENTITIES.addElement(new String[]{"\u00f7", "&Ouml;"});
        HTML_ENTITIES.addElement(new String[]{"\u0178", "&Ugrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u2044", "&Uacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u20ac", "&Ucirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u2039", "&Uuml;"});
        HTML_ENTITIES.addElement(new String[]{"\u203a", "&Yacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u2021", "&agrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u00b7", "&aacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u201a", "&acirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u201e", "&atilde;"});
        HTML_ENTITIES.addElement(new String[]{"\u2030", "&auml;"});
        HTML_ENTITIES.addElement(new String[]{"\u00ca", "&aelig;"});
        HTML_ENTITIES.addElement(new String[]{"\u00c1", "&ccedil;"});
        HTML_ENTITIES.addElement(new String[]{"\u00cb", "&egrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u00c8", "&eacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u00cd", "&ecirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u00ce", "&euml;"});
        HTML_ENTITIES.addElement(new String[]{"\u00cf", "&igrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u00cc", "&iacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u00d3", "&icirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u00d4", "&iuml;"});
        HTML_ENTITIES.addElement(new String[]{"\uf8ff", "&eth;"});
        HTML_ENTITIES.addElement(new String[]{"\u00d2", "&ntilde;"});
        HTML_ENTITIES.addElement(new String[]{"\u00da", "&ograve;"});
        HTML_ENTITIES.addElement(new String[]{"\u00db", "&oacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u00d9", "&ocirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u0131", "&otilde;"});
        HTML_ENTITIES.addElement(new String[]{"\u02c6", "&ouml;"});
        HTML_ENTITIES.addElement(new String[]{"\u02d8", "&ugrave;"});
        HTML_ENTITIES.addElement(new String[]{"\u02d9", "&uacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u02da", "&ucirc;"});
        HTML_ENTITIES.addElement(new String[]{"\u00b8", "&uuml;"});
        HTML_ENTITIES.addElement(new String[]{"\u02dd", "&yacute;"});
        HTML_ENTITIES.addElement(new String[]{"\u02c7", "&yuml;"});
        HTML_ENTITIES.addElement(new String[]{"-", "&mdash;"});
        HTML_2_XML_ENTITIES = new Hashtable();
        HTML_2_XML_ENTITIES.put("&amp;", "&#038;");
        HTML_2_XML_ENTITIES.put("&ouml;", "&#246;");
        HTML_2_XML_ENTITIES.put("&auml;", "&#228;");
        HTML_2_XML_ENTITIES.put("&uuml;", "&#252;");
        HTML_2_XML_ENTITIES.put("&Uuml;", "&#220;");
        HTML_2_XML_ENTITIES.put("&Ouml;", "&#214;");
        HTML_2_XML_ENTITIES.put("&Auml;", "&#196;");
        HTML_2_XML_ENTITIES.put("&quot;", "&#034;");
        HTML_2_XML_ENTITIES.put("&sect;", "&#167;");
        HTML_2_XML_ENTITIES.put("&szlig;", "&#223;");
        HTML_2_XML_ENTITIES.put("&lt;", "&#060;");
        HTML_2_XML_ENTITIES.put("&gt;", "&#062;");
        HTML_2_XML_ENTITIES.put("&euro;", "&#198;");
        HTML_2_XML_ENTITIES.put("\u00c1", "&#135;");
        HTML_2_XML_ENTITIES.put("\u00b7", "&#160;");
        HTML_2_XML_ENTITIES.put("&agrave;", "&#133;");
        HTML_2_XML_ENTITIES.put("&acirc;", "&#131;");
        HTML_2_XML_ENTITIES.put("&Agrave;", "&#192;");
        HTML_2_XML_ENTITIES.put("&Aacute;", "&#193;");
        HTML_2_XML_ENTITIES.put("&Acirc;", "&#194;");
        HTML_2_XML_ENTITIES.put("&Atilde;", "&#195;");
        HTML_2_XML_ENTITIES.put("&Auml;", "&#196;");
        HTML_2_XML_ENTITIES.put("&Aring;", "&#197;");
        HTML_2_XML_ENTITIES.put("&AElig;", "&#198;");
        HTML_2_XML_ENTITIES.put("&Ccedil;", "&#199;");
        HTML_2_XML_ENTITIES.put("&Egrave;", "&#200;");
        HTML_2_XML_ENTITIES.put("&Eacute;", "&#201;");
        HTML_2_XML_ENTITIES.put("&Ecirc;", "&#202;");
        HTML_2_XML_ENTITIES.put("&Euml;", "&#203;");
        HTML_2_XML_ENTITIES.put("&Igrave;", "&#204;");
        HTML_2_XML_ENTITIES.put("&Iacute;", "&#205;");
        HTML_2_XML_ENTITIES.put("&Icirc;", "&#206;");
        HTML_2_XML_ENTITIES.put("&Iuml;", "&#207;");
        HTML_2_XML_ENTITIES.put("&Ntilde;", "&#209;");
        HTML_2_XML_ENTITIES.put("&Ograve;", "&#210;");
        HTML_2_XML_ENTITIES.put("&Oacute;", "&#211;");
        HTML_2_XML_ENTITIES.put("&Ocirc;", "&#212;");
        HTML_2_XML_ENTITIES.put("&Otilde;", "&#213;");
        HTML_2_XML_ENTITIES.put("&Ouml;", "&#214;");
        HTML_2_XML_ENTITIES.put("&Ugrave;", "&#217;");
        HTML_2_XML_ENTITIES.put("&Uacute;", "&#218;");
        HTML_2_XML_ENTITIES.put("&Ucirc;", "&#219;");
        HTML_2_XML_ENTITIES.put("&Uuml;", "&#220;");
        HTML_2_XML_ENTITIES.put("&Yacute;", "&#221;");
        HTML_2_XML_ENTITIES.put("&agrave;", "&#224;");
        HTML_2_XML_ENTITIES.put("&aacute;", "&#225;");
        HTML_2_XML_ENTITIES.put("&acirc;", "&#226;");
        HTML_2_XML_ENTITIES.put("&atilde;", "&#227;");
        HTML_2_XML_ENTITIES.put("&aelig;", "&#230;");
        HTML_2_XML_ENTITIES.put("&ccedil;", "&#231;");
        HTML_2_XML_ENTITIES.put("&egrave;", "&#232;");
        HTML_2_XML_ENTITIES.put("&eacute;", "&#233;");
        HTML_2_XML_ENTITIES.put("&ecirc;", "&#234;");
        HTML_2_XML_ENTITIES.put("&euml;", "&#235;");
        HTML_2_XML_ENTITIES.put("&igrave;", "&#236;");
        HTML_2_XML_ENTITIES.put("&iacute;", "&#237;");
        HTML_2_XML_ENTITIES.put("&icirc;", "&#238;");
        HTML_2_XML_ENTITIES.put("&iuml;", "&#239;");
        HTML_2_XML_ENTITIES.put("&eth;", "&#240;");
        HTML_2_XML_ENTITIES.put("&ntilde;", "&#241;");
        HTML_2_XML_ENTITIES.put("&ograve;", "&#242;");
        HTML_2_XML_ENTITIES.put("&oacute;", "&#243;");
        HTML_2_XML_ENTITIES.put("&ocirc;", "&#244;");
        HTML_2_XML_ENTITIES.put("&otilde;", "&#245;");
        HTML_2_XML_ENTITIES.put("&ugrave;", "&#249;");
        HTML_2_XML_ENTITIES.put("&uacute;", "&#250;");
        HTML_2_XML_ENTITIES.put("&ucirc;", "&#251;");
        HTML_2_XML_ENTITIES.put("&uuml;", "&#252;");
        HTML_2_XML_ENTITIES.put("&yacute;", "&#253;");
        HTML_2_XML_ENTITIES.put("&yuml;", "&#255;");
        HTML_2_XML_ENTITIES.put("&mdash;", "&#8212;");
    }
}

