/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.util.paging;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anoplass.api.util.paging.PagingCurrentPage;
import net.anotheria.anoplass.api.util.paging.PagingElement;
import net.anotheria.anoplass.api.util.paging.PagingLink;
import net.anotheria.anoplass.api.util.paging.Separator;

public class PagingControl {
    private int currentPage;
    private int numberOfElements;
    private int elementsPerPage;
    private int maxEntries;
    private boolean moreHitsAvailable;
    private List<PagingElement> elements;

    public PagingControl() {
        this(1, 1, 1);
    }

    public PagingControl(int aCurrentPage, int anElementsPerPage, int aNumberOfElements) {
        this(aCurrentPage, anElementsPerPage, aNumberOfElements, false);
    }

    public PagingControl(int aCurrentPage, int anElementsPerPage, int aNumberOfElements, boolean aMoreHitsAvailable) {
        this.currentPage = aCurrentPage;
        this.elementsPerPage = anElementsPerPage;
        this.numberOfElements = aNumberOfElements;
        this.elements = new ArrayList<PagingElement>();
        this.moreHitsAvailable = aMoreHitsAvailable;
        this.setup();
    }

    public String toString() {
        return "currentPage:" + this.currentPage + ", numberOfElements:" + this.numberOfElements + ", elementsPerPage:" + this.elementsPerPage + ", maxEntries:" + this.maxEntries + ", moreHitsAvailable:" + this.moreHitsAvailable;
    }

    void setup() {
        int numberOfPages = this.getNumberOfPages();
        for (int i = 1; i <= numberOfPages; ++i) {
            boolean addLink;
            if (i == this.currentPage) {
                this.elements.add(new PagingCurrentPage("" + i));
                continue;
            }
            boolean bl = addLink = numberOfPages <= 7 ? true : this.addLink(i, this.currentPage, numberOfPages);
            if (addLink) {
                this.elements.add(new PagingLink("" + i, i));
            }
            if (addLink || this.elements.get(this.elements.size() - 1).isSeparator()) continue;
            this.elements.add(new Separator());
        }
    }

    private boolean addLink(int page, int selectedPage, int numberOfPages) {
        if (page == 1 || page == numberOfPages) {
            return true;
        }
        return selectedPage > page && selectedPage - page <= 2 || page > selectedPage && page - selectedPage <= 2;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public int getNumberOfPages() {
        int numberOfPages = this.numberOfElements / this.elementsPerPage;
        if (numberOfPages * this.elementsPerPage < this.numberOfElements) {
            ++numberOfPages;
        }
        return numberOfPages;
    }

    public List<PagingElement> getElements() {
        return this.elements;
    }

    public boolean hasNext() {
        return this.currentPage < this.getNumberOfPages();
    }

    public boolean isHasNext() {
        return this.hasNext();
    }

    public boolean hasPrevious() {
        return this.currentPage >= 2;
    }

    public boolean isHasPrevious() {
        return this.hasPrevious();
    }

    public int getElementsPerPage() {
        return this.elementsPerPage;
    }

    public boolean isLast() {
        return this.currentPage == this.getNumberOfPages();
    }

    public boolean isFirst() {
        return this.currentPage == 1;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int aMaxEntries) {
        this.maxEntries = aMaxEntries;
    }

    public boolean isMoreHitsAvailable() {
        return this.moreHitsAvailable;
    }

    public int getCurrentPageNumber() {
        return this.currentPage;
    }

    public int getNextPageNumber() {
        return this.currentPage + 1;
    }

    public int getPreviousPageNumber() {
        return this.currentPage - 1;
    }
}

