/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.session;

import java.io.Serializable;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.session.PolicyHelper;

public class AttributeWrapper
implements Serializable {
    private static final long serialVersionUID = 2709101589774990085L;
    private Object value;
    private int policy;
    private String key;
    private long expiryTimestamp;
    private boolean dirty;

    public AttributeWrapper(String aKey, Object aValue, int aPolicy) {
        this(aKey, aValue, aPolicy, PolicyHelper.isAutoExpiring(aPolicy) ? System.currentTimeMillis() + APISession.DEFAULT_EXPIRE_PERIOD : 0L);
    }

    public AttributeWrapper(String aKey, Object aValue, int aPolicy, long expiresWhen) {
        this.key = aKey;
        this.value = aValue;
        this.policy = aPolicy;
        this.expiryTimestamp = expiresWhen;
    }

    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int aPolicy) {
        this.policy = aPolicy;
    }

    public Object getValue() {
        return this.isExpired() ? null : this.value;
    }

    public void setValue(Object aValue) {
        this.value = aValue;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public boolean isExpiring() {
        return (this.policy & 8) == 8;
    }

    public boolean isFlashing() {
        return (this.policy & 0x80) == 128;
    }

    public long getExpiryTimestamp() {
        return this.expiryTimestamp;
    }

    public void setExpiryTimestamp(long expiryTimestamp) {
        this.expiryTimestamp = expiryTimestamp;
    }

    public boolean isExpired() {
        return this.isExpiring() && System.currentTimeMillis() > this.expiryTimestamp;
    }

    public String toString() {
        return "Key: " + this.getKey() + ", Value: " + this.getValue() + ", Policy: " + this.getPolicy();
    }

    public boolean isSerializable() {
        return this.value instanceof Serializable;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

