/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.session.APISessionCreationException;
import net.anotheria.anoplass.api.session.APISessionDistributionConfig;
import net.anotheria.anoplass.api.session.APISessionDistributionException;
import net.anotheria.anoplass.api.session.APISessionDistributionHelper;
import net.anotheria.anoplass.api.session.APISessionImpl;
import net.anotheria.anoplass.api.session.APISessionManagerListener;
import net.anotheria.anoplass.api.session.APISessionRestoreException;
import net.anotheria.anoplass.api.session.AttributeWrapper;
import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventService;
import net.anotheria.anoprise.eventservice.EventServiceConsumer;
import net.anotheria.anoprise.eventservice.EventServiceFactory;
import net.anotheria.anoprise.eventservice.EventServiceParticipant;
import net.anotheria.anoprise.eventservice.EventServicePushConsumer;
import net.anotheria.anoprise.eventservice.util.QueuedEventReceiver;
import net.anotheria.anoprise.processor.ElementWorker;
import net.anotheria.anoprise.processor.QueuedMultiProcessor;
import net.anotheria.anoprise.processor.QueuedMultiProcessorBuilder;
import net.anotheria.anoprise.processor.UnrecoverableQueueOverflowException;
import net.anotheria.anoprise.sessiondistributor.events.SessionDistributorEvent;
import net.anotheria.anoprise.sessiondistributor.events.SessionRestoreEvent;
import net.anotheria.moskito.core.util.storage.Storage;
import net.anotheria.util.IdCodeGenerator;
import net.anotheria.util.StringUtils;
import org.distributeme.support.eventservice.generated.EventServiceRMIBridgeServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APISessionManager {
    private static final int SERVICE_ID_LENGTH = 10;
    private static final String API_SESSION_QUEUED_MULTIPROCESSOR_NAME = "apiSessionManagerQueuedMultiProcessor";
    private static final Logger MULTI_PROCESSOR_LOGGER = LoggerFactory.getLogger((String)"APISessionManager_MultiProcessor_LOGGER");
    private static APISessionManager instance = new APISessionManager();
    private Storage<String, APISession> sessions;
    private Storage<String, String> referenceIds;
    private Map<String, Long> distributedSessionLastCallTime;
    private List<APISessionManagerListener> listeners;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private APISessionDistributionConfig distributionConfig;
    private APISessionImpl.APISessionCallBack callback;
    private QueuedMultiProcessor<APISessionEvent> processor;
    private String serviceId;

    private APISessionManager() {
        this.sessions = Storage.createConcurrentHashMapStorage((String)"sessions");
        this.referenceIds = Storage.createConcurrentHashMapStorage((String)"session-refIds");
        this.listeners = new CopyOnWriteArrayList<APISessionManagerListener>();
        this.distributionConfig = APISessionDistributionConfig.getInstance();
        this.callback = new APISessionCallBackImpl();
        this.serviceId = "APISessionManager_" + IdCodeGenerator.generateCode((int)10);
        this.configureIntegration();
    }

    private void configureIntegration() {
        this.distributedSessionLastCallTime = new ConcurrentHashMap<String, Long>();
        if (!this.distributionConfig.isDistributionEnabled()) {
            return;
        }
        if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
            return;
        }
        this.log.info("APISessionManager SessionDistributorConsumer INITIALIZATION: STARTED");
        try {
            EventServiceRMIBridgeServer.init();
            EventServiceRMIBridgeServer.createServiceAndRegisterLocally();
            EventService eventService = EventServiceFactory.createEventService();
            SessionDistributorConsumer usConsumer = new SessionDistributorConsumer();
            QueuedEventReceiver sessionDistributorEventReceiver = new QueuedEventReceiver("SessionDistributorEventReceiver", "sessiondistributor_channel", (EventServicePushConsumer)usConsumer, this.distributionConfig.getSessionDistributorEventReceiverQueueSize(), this.distributionConfig.getSessionDistributorEventReceiverQueueSleepTime(), this.log);
            eventService.obtainEventChannel("sessiondistributor_channel", (EventServiceParticipant)sessionDistributorEventReceiver).addConsumer((EventServiceConsumer)sessionDistributorEventReceiver);
            sessionDistributorEventReceiver.start();
            this.log.info("APISessionManager SessionDistributorConsumer INITIALIZATION: FINISHED. Waiting for events...");
        }
        catch (Exception e) {
            this.log.error("SessionDistributorEventReceiver init failed.", (Throwable)e);
        }
        this.processor = new QueuedMultiProcessorBuilder().setSleepTime(this.distributionConfig.getApiSessionEventSenderQueueSleepTime()).setQueueSize(this.distributionConfig.getApiSessionEventSenderQueueSize()).setProcessorChannels(this.distributionConfig.getApiSessionEventSenderQueueProcessingChannelsAmount()).setProcessingLog(MULTI_PROCESSOR_LOGGER).attachMoskitoLoggers("APISessionManager : APISession-Distribution events processor", "storage", "default").build(API_SESSION_QUEUED_MULTIPROCESSOR_NAME, (ElementWorker)new SessionWorker());
        this.processor.start();
    }

    public static APISessionManager getInstance() {
        return instance;
    }

    public APISession obtainSession(String httpSessionId, String apiSessionId, String dSessionIdFromCookies, String dSessionIdRequestParam, String remoteAddress, String userAgent, Locale locale, String editorId) throws APISessionCreationException {
        if (StringUtils.isEmpty((String)httpSessionId)) {
            throw new IllegalArgumentException("Invalid httpSessionId passed");
        }
        APICallContext.getCallContext().reset();
        APISession session = null;
        if (!(!this.isDistributionEnabledAndProperlyConfigured() || StringUtils.isEmpty((String)dSessionIdRequestParam) || dSessionIdRequestParam.equals(apiSessionId) && apiSessionId != null)) {
            try {
                session = this.restoreSession(dSessionIdRequestParam, httpSessionId);
                if (session != null) {
                    return this.populateAdditionalParameters(remoteAddress, userAgent, editorId, locale, session);
                }
            }
            catch (APISessionRestoreException e) {
                this.log.warn("restoreSession(" + dSessionIdRequestParam + ", " + httpSessionId + ") failed. " + e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)apiSessionId)) {
            if (this.isDistributionEnabledAndProperlyConfigured() && !StringUtils.isEmpty((String)dSessionIdFromCookies)) {
                try {
                    session = this.restoreSession(dSessionIdFromCookies, httpSessionId);
                }
                catch (APISessionRestoreException e) {
                    this.log.warn("restoreSession(" + dSessionIdRequestParam + ", " + httpSessionId + ") failed. " + e.getMessage());
                }
            }
            session = session == null ? this.createSession(httpSessionId) : session;
            return this.populateAdditionalParameters(remoteAddress, userAgent, editorId, locale, session);
        }
        session = this.getSession(apiSessionId);
        if (session == null) {
            session = this.createSession(httpSessionId);
        }
        return this.populateAdditionalParameters(remoteAddress, userAgent, editorId, locale, session);
    }

    @Deprecated
    public APISession obtainSession(String referenceId) throws APISessionCreationException {
        return this.obtainSession(referenceId, "", "", "", "", "", null, "");
    }

    private APISession populateAdditionalParameters(String remoteAddress, String userAgent, String editorId, Locale locale, APISession currentAPISession) {
        APICallContext currentContext = APICallContext.getCallContext();
        currentAPISession.setIpAddress(remoteAddress);
        currentAPISession.setUserAgent(userAgent);
        currentContext.setCurrentSession(currentAPISession);
        Locale localeToSet = currentAPISession.getLocale() == null ? locale : currentAPISession.getLocale();
        currentContext.setCurrentLocale(localeToSet);
        if (!StringUtils.isEmpty((String)editorId)) {
            currentContext.setCurrentEditorId(editorId);
        }
        currentContext.setCurrentUserId(currentAPISession.getCurrentUserId());
        return currentAPISession;
    }

    protected APISession createSession(String referenceId) throws APISessionCreationException {
        APISessionImpl session = new APISessionImpl(this.createAPISessionId());
        ((APISessionImpl)APISessionImpl.class.cast(session)).setReferenceId(referenceId);
        this.sessions.put((Object)session.getId(), (Object)session);
        this.referenceIds.put((Object)referenceId, (Object)session.getId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("createSession, id=" + session.getId());
        }
        if (this.isDistributionEnabledAndProperlyConfigured()) {
            this.distributedSessionLastCallTime.put(session.getId(), System.currentTimeMillis());
            ((APISessionImpl)APISessionImpl.class.cast(session)).setSessionCallBack(this.callback);
        }
        return session;
    }

    protected APISession restoreSession(String sessionId, String referenceId) throws APISessionRestoreException {
        if (!this.distributionConfig.isDistributionEnabled()) {
            throw new APISessionRestoreException(sessionId, "SessionDistribution is turned OFF!");
        }
        if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
            throw new APISessionRestoreException(sessionId, "SessionDistribution is not properly configured!");
        }
        try {
            APISession restored = APISessionDistributionHelper.restoreSession(sessionId, this.serviceId);
            if (!(restored instanceof APISessionImpl)) {
                throw new APISessionRestoreException(sessionId, "Unknown implementation was restored! Skipping.");
            }
            APISessionImpl session = (APISessionImpl)APISessionImpl.class.cast(restored);
            session.setSessionCallBack(this.callback);
            session.setReferenceId(referenceId);
            this.sessions.put((Object)session.getId(), (Object)session);
            this.referenceIds.put((Object)referenceId, (Object)session.getId());
            this.distributedSessionLastCallTime.put(session.getId(), System.currentTimeMillis());
            if (this.log.isDebugEnabled()) {
                this.log.debug("session restored, id=" + session.getId());
            }
            return restored;
        }
        catch (APISessionDistributionException e) {
            this.log.error("session restore failed session[" + sessionId + "]", (Throwable)e);
            throw new APISessionRestoreException(sessionId, e);
        }
    }

    private String createAPISessionId() throws APISessionCreationException {
        String sessionId = IdCodeGenerator.generateCode((int)30);
        return this.createAndGetAssociatedDistributedSessionId(sessionId);
    }

    private String createAndGetAssociatedDistributedSessionId(String sessionId) throws APISessionCreationException {
        if (this.isDistributionEnabledAndProperlyConfigured()) {
            try {
                sessionId = APISessionDistributionHelper.createSession(sessionId);
            }
            catch (APISessionDistributionException e) {
                this.log.error("Distributed session " + sessionId + " creation failure", (Throwable)e);
                throw new APISessionCreationException(sessionId, e);
            }
        }
        return sessionId;
    }

    public ArrayList<String> getReferenceIds() {
        ArrayList<String> ret = new ArrayList<String>(this.referenceIds.size());
        for (String id : this.referenceIds.keySet()) {
            ret.add(id);
        }
        return ret;
    }

    public ArrayList<String> getSessionIds() {
        ArrayList<String> ret = new ArrayList<String>(this.sessions.size());
        for (String id : this.sessions.keySet()) {
            ret.add(id);
        }
        return ret;
    }

    public APISession getSession(String id) {
        APISession session = (APISession)this.sessions.get((Object)id);
        if (this.isDistributionEnabledAndProperlyConfigured() && session != null) {
            Long lastCall = this.distributedSessionLastCallTime.get(id);
            lastCall = lastCall == null ? System.currentTimeMillis() : lastCall;
            if (System.currentTimeMillis() - lastCall >= this.distributionConfig.getDistributedSessionKeepAliveCallInterval()) {
                this.callback.keepAliveCall(id);
                this.distributedSessionLastCallTime.put(session.getId(), System.currentTimeMillis());
            }
        }
        return session;
    }

    public int getSessionCount() {
        return this.sessions.size();
    }

    public APISession getSessionByReferenceId(String aReferenceId) {
        String sessionId = (String)this.referenceIds.get((Object)aReferenceId);
        if (sessionId == null) {
            throw new RuntimeException("Can't find session for referenceId: " + aReferenceId);
        }
        return this.getSession(sessionId);
    }

    public void destroyAPISessionByReferenceId(String referenceId) {
        String sessionId = (String)this.referenceIds.get((Object)referenceId);
        if (sessionId == null) {
            return;
        }
        APISession session = (APISession)this.sessions.remove((Object)sessionId);
        if (session == null) {
            this.log.info("HttpSession expired " + referenceId + ", no api session connected");
            return;
        }
        for (APISessionManagerListener listener : this.listeners) {
            listener.apiSessionDestroyed(session);
        }
        this.destroyDistributedSession(sessionId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("HttpSession expired: " + referenceId + ", ApiSessionId: " + session.getId());
        }
        ((APISessionImpl)session).clear();
        if (this.distributionConfig.isDistributionEnabled()) {
            this.distributedSessionLastCallTime.remove(session.getId());
        }
        this.referenceIds.remove((Object)referenceId);
    }

    public void destroyAPISessionBySessionId(String sessionId) {
        if (StringUtils.isEmpty((String)sessionId)) {
            return;
        }
        APISession session = (APISession)this.sessions.remove((Object)sessionId);
        if (session == null) {
            return;
        }
        for (APISessionManagerListener listener : this.listeners) {
            listener.apiSessionDestroyed(session);
        }
        this.destroyDistributedSession(sessionId);
        ((APISessionImpl)APISessionImpl.class.cast(session)).clear();
        if (this.distributionConfig.isDistributionEnabled() && this.distributedSessionLastCallTime != null) {
            this.distributedSessionLastCallTime.remove(session.getId());
        }
        this.referenceIds.remove((Object)((APISessionImpl)APISessionImpl.class.cast(session)).getReferenceId());
    }

    private void destroyDistributedSession(String sessionId) {
        if (this.isDistributionEnabledAndProperlyConfigured()) {
            APISessionDistributionHelper.removeDistributedSession(sessionId);
        }
    }

    public void addAPISessionManagerListener(APISessionManagerListener listener) {
        this.listeners.add(listener);
    }

    private boolean isDistributionEnabledAndProperlyConfigured() {
        return this.distributionConfig.isDistributionEnabled() && APISessionDistributionHelper.isSessionDistributorServiceConfigured();
    }

    private void removeRestoredSession(String aSessionId, String aCallServiceId) {
        if (this.serviceId.equals(aCallServiceId)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Do nothing ! we are at host which just restored session[" + aSessionId + "]");
            }
            return;
        }
        APISession session = (APISession)this.sessions.remove((Object)aSessionId);
        if (session == null) {
            return;
        }
        for (APISessionManagerListener listener : this.listeners) {
            listener.apiSessionDestroyed(session);
        }
        ((APISessionImpl)APISessionImpl.class.cast(session)).clear();
        this.distributedSessionLastCallTime.remove(session.getId());
        this.referenceIds.remove((Object)((APISessionImpl)APISessionImpl.class.cast(session)).getReferenceId());
    }

    private class SessionWorker
    implements ElementWorker<APISessionEvent> {
        private SessionWorker() {
        }

        public void doWork(APISessionEvent workingElement) throws Exception {
            if (APISessionManager.this.log.isDebugEnabled()) {
                APISessionManager.this.log.debug("Working on element" + workingElement);
            }
            switch (workingElement.getType()) {
                case ATTRIBUTE_ADD: {
                    APISessionDistributionHelper.addAttributeToDistributedSession(workingElement.getApiSessionId(), workingElement.getWrapper());
                    if (APISessionManager.this.log.isDebugEnabled()) {
                        APISessionManager.this.log.debug("ATTRIBUTE_ADD" + workingElement);
                    }
                    return;
                }
                case ATTRIBUTE_REMOVE: {
                    APISessionDistributionHelper.removeAttributeFromDistributedSession(workingElement.getApiSessionId(), workingElement.getAttributeName());
                    if (APISessionManager.this.log.isDebugEnabled()) {
                        APISessionManager.this.log.debug("ATTRIBUTE_REMOVE" + workingElement);
                    }
                    return;
                }
                case USER_ID_SET: {
                    APISessionDistributionHelper.updateDistributedSessionUserId(workingElement.getApiSessionId(), workingElement.getUserId());
                    if (APISessionManager.this.log.isDebugEnabled()) {
                        APISessionManager.this.log.debug("USER_ID_SET" + workingElement);
                    }
                    return;
                }
                case EDITOR_ID_SET: {
                    APISessionDistributionHelper.updateDistributedSessionEditorId(workingElement.getApiSessionId(), workingElement.getEditorId());
                    if (APISessionManager.this.log.isDebugEnabled()) {
                        APISessionManager.this.log.debug("EDITOR_ID_SET" + workingElement);
                    }
                    return;
                }
                case KEEP_ALIVE_CALL: {
                    APISessionDistributionHelper.keepSessionAliveCall(workingElement.getApiSessionId());
                    if (APISessionManager.this.log.isDebugEnabled()) {
                        APISessionManager.this.log.debug("KEEP_ALIVE_CALL" + workingElement);
                    }
                    return;
                }
            }
            if (APISessionManager.this.log.isDebugEnabled()) {
                APISessionManager.this.log.debug("element process completed");
            }
        }
    }

    private static class APISessionEvent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CallBackOperationType type;
        private String apiSessionId;
        private String userId;
        private String editorId;
        private String attributeName;
        private AttributeWrapper wrapper;

        public APISessionEvent(String aSessionId, CallBackOperationType aType) {
            this.apiSessionId = aSessionId;
            this.type = aType;
        }

        public String getApiSessionId() {
            return this.apiSessionId;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public String getEditorId() {
            return this.editorId;
        }

        public void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        public CallBackOperationType getType() {
            return this.type;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public AttributeWrapper getWrapper() {
            return this.wrapper;
        }

        public void setWrapper(AttributeWrapper wrapper) {
            this.wrapper = wrapper;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("APISessionEvent");
            sb.append("{apiSessionId='").append(this.apiSessionId).append('\'');
            sb.append(", type=").append((Object)this.type);
            sb.append(", userId='").append(this.userId).append('\'');
            sb.append(", editorId='").append(this.editorId).append('\'');
            sb.append(", attributeName='").append(this.attributeName).append('\'');
            sb.append(", wrapper=").append(this.wrapper);
            sb.append('}');
            return sb.toString();
        }
    }

    private static enum CallBackOperationType {
        ATTRIBUTE_ADD,
        ATTRIBUTE_REMOVE,
        USER_ID_SET,
        EDITOR_ID_SET,
        KEEP_ALIVE_CALL;

    }

    protected class SessionDistributorConsumer
    implements EventServicePushConsumer {
        private final Logger log = LoggerFactory.getLogger(SessionDistributorConsumer.class);

        protected SessionDistributorConsumer() {
        }

        public void push(Event event) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("SessionDistributor  service event: " + event);
            }
            if (event == null || event.getData() == null || !(event.getData() instanceof SessionDistributorEvent)) {
                return;
            }
            SessionDistributorEvent someEvent = (SessionDistributorEvent)event.getData();
            switch (someEvent.getOperation()) {
                case SESSION_RESTORE: {
                    SessionRestoreEvent restore = (SessionRestoreEvent)someEvent;
                    APISessionManager.this.removeRestoredSession(restore.getSessionId(), restore.getServiceId());
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Incoming RESTORE EVENT!" + restore);
                    break;
                }
                case SESSION_DELETE: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Current method SESSION_DELETE not used currently" + event);
                    break;
                }
                case SESSION_CLEAN_UP: {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Current method SESSION_CLEAN_UP not used currently" + event);
                }
            }
        }
    }

    private class APISessionCallBackImpl
    implements APISessionImpl.APISessionCallBack {
        private APISessionCallBackImpl() {
        }

        @Override
        public void attributeSet(String sessionId, AttributeWrapper aWrapper) {
            if (!APISessionManager.this.distributionConfig.isDistributionEnabled()) {
                return;
            }
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            if (APISessionManager.this.processor == null) {
                APISessionManager.this.log.error("Session distribution is enabled but processor is not configured! ");
                return;
            }
            if (!aWrapper.isSerializable()) {
                APISessionManager.this.log.error("Attribute " + aWrapper + " is not serializable! Ignoring.");
                return;
            }
            APISessionEvent event = new APISessionEvent(sessionId, CallBackOperationType.ATTRIBUTE_ADD);
            event.setWrapper(aWrapper);
            try {
                APISessionManager.this.processor.addToQueueDontWait((Object)event);
                APISessionManager.this.distributedSessionLastCallTime.put(sessionId, System.currentTimeMillis());
            }
            catch (UnrecoverableQueueOverflowException e) {
                APISessionManager.this.log.error("Queue is Full. Session " + sessionId + " add attribute " + aWrapper.getKey() + " distribution skipped.", (Throwable)e);
            }
        }

        @Override
        public void attributeRemoved(String sessionId, String attributeName) {
            if (!APISessionManager.this.distributionConfig.isDistributionEnabled()) {
                return;
            }
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            if (APISessionManager.this.processor == null) {
                APISessionManager.this.log.error("Session distribution is enabled but processor is not configured! ");
                return;
            }
            APISessionEvent event = new APISessionEvent(sessionId, CallBackOperationType.ATTRIBUTE_REMOVE);
            event.setAttributeName(attributeName);
            try {
                APISessionManager.this.processor.addToQueueDontWait((Object)event);
                APISessionManager.this.distributedSessionLastCallTime.put(sessionId, System.currentTimeMillis());
            }
            catch (UnrecoverableQueueOverflowException e) {
                APISessionManager.this.log.error("Queue is Full. Session " + sessionId + " remove attribute " + attributeName + " distribution skipped.", (Throwable)e);
            }
        }

        @Override
        public void currentUserIdChanged(String sessionId, String userId) {
            if (!APISessionManager.this.distributionConfig.isDistributionEnabled()) {
                return;
            }
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            if (APISessionManager.this.processor == null) {
                APISessionManager.this.log.error("Session distribution is enabled but processor is not configured! ");
                return;
            }
            APISessionEvent event = new APISessionEvent(sessionId, CallBackOperationType.USER_ID_SET);
            event.setUserId(userId);
            try {
                APISessionManager.this.processor.addToQueueDontWait((Object)event);
                APISessionManager.this.distributedSessionLastCallTime.put(sessionId, System.currentTimeMillis());
            }
            catch (UnrecoverableQueueOverflowException e) {
                APISessionManager.this.log.error("Queue is Full. Session " + sessionId + " update userId " + userId + " distribution skipped.", (Throwable)e);
            }
        }

        @Override
        public void editorIdChanged(String sessionId, String editorId) {
            if (!APISessionManager.this.distributionConfig.isDistributionEnabled()) {
                return;
            }
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            if (APISessionManager.this.processor == null) {
                APISessionManager.this.log.error("Session distribution is enabled but processor is not configured! ");
                return;
            }
            APISessionEvent event = new APISessionEvent(sessionId, CallBackOperationType.EDITOR_ID_SET);
            event.setEditorId(editorId);
            try {
                APISessionManager.this.processor.addToQueueDontWait((Object)event);
                APISessionManager.this.distributedSessionLastCallTime.put(sessionId, System.currentTimeMillis());
            }
            catch (UnrecoverableQueueOverflowException e) {
                APISessionManager.this.log.error("Queue is Full. Session " + sessionId + " update editorId " + editorId + " distribution skipped.", (Throwable)e);
            }
        }

        @Override
        public void keepAliveCall(String sessionId) {
            if (!APISessionManager.this.distributionConfig.isDistributionEnabled()) {
                return;
            }
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            if (APISessionManager.this.processor == null) {
                APISessionManager.this.log.error("Session distribution is enabled but processor is not configured! ");
                return;
            }
            APISessionEvent event = new APISessionEvent(sessionId, CallBackOperationType.KEEP_ALIVE_CALL);
            try {
                APISessionManager.this.processor.addToQueueDontWait((Object)event);
                APISessionManager.this.distributedSessionLastCallTime.put(sessionId, System.currentTimeMillis());
            }
            catch (UnrecoverableQueueOverflowException e) {
                APISessionManager.this.log.error("Queue is Full. Session " + sessionId + " keep alive call skipped.", (Throwable)e);
            }
        }
    }
}

