/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.session;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.session.AttributeWrapper;
import net.anotheria.anoplass.api.session.PolicyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APISessionImpl
implements APISession,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Map<String, AttributeWrapper> attributes;
    private String ipAddress;
    private String userAgent;
    private String referenceId;
    private String currentUserId;
    private String currentEditorId;
    private Locale locale;
    private transient APISessionCallBack sessionCallBack;
    private Map<String, Object> actionScope;
    private static Logger log = LoggerFactory.getLogger(APISessionImpl.class);

    APISessionImpl(String anId) {
        this.id = anId;
        this.attributes = new ConcurrentHashMap<String, AttributeWrapper>();
        this.actionScope = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public Object getAttribute(String key) {
        AttributeWrapper wrapper = this.attributes.get(key);
        if (wrapper != null && wrapper.isFlashing()) {
            this.removeAttribute(key);
        }
        return wrapper == null ? null : wrapper.getValue();
    }

    public AttributeWrapper getAttributeWrapper(String key) {
        return this.attributes.get(key);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setAttribute(String key, int policy, Object value) {
        AttributeWrapper wrapper = new AttributeWrapper(key, value, policy);
        this.attributes.put(key, wrapper);
        if (this.canDistribute(wrapper)) {
            this.sessionCallBack.attributeSet(this.getId(), wrapper);
        }
    }

    @Override
    public void setAttribute(String key, int policy, Object value, long expiresWhen) {
        AttributeWrapper wrapper = new AttributeWrapper(key, value, policy, expiresWhen);
        this.attributes.put(key, wrapper);
        if (this.canDistribute(wrapper)) {
            this.sessionCallBack.attributeSet(this.getId(), wrapper);
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.setAttribute(key, 1, value);
    }

    @Override
    public void removeAttribute(String key) {
        AttributeWrapper wrapper = this.attributes.get(key);
        this.attributes.remove(key);
        if (this.canDistribute(wrapper)) {
            this.sessionCallBack.attributeRemoved(this.getId(), key);
        }
    }

    @Override
    public List<String> getAttributeNames() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public String toString() {
        return "Id: " + this.id + ", attributes: " + this.attributes.size();
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIpAddress(String anIpAddress) {
        String oldIpAddress = this.ipAddress;
        this.ipAddress = anIpAddress;
        if (oldIpAddress != null && !oldIpAddress.equals(this.ipAddress)) {
            log.warn(this + " session switches ip from " + oldIpAddress + ", to: " + this.ipAddress);
        }
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setUserAgent(String anUserAgent) {
        this.userAgent = anUserAgent;
    }

    void clear() {
        this.attributes.clear();
    }

    @Override
    public void cleanupOnLogout() {
        for (AttributeWrapper w : this.getAttributes()) {
            if (PolicyHelper.isPolicySet(w.getPolicy(), 32)) continue;
            this.attributes.remove(w.getKey());
            if (!this.canDistribute(w)) continue;
            this.sessionCallBack.attributeRemoved(this.getId(), w.getKey());
        }
    }

    Collection<AttributeWrapper> getAttributes() {
        return this.attributes.values();
    }

    void setAttributeWrapper(AttributeWrapper w) {
        this.attributes.put(w.getKey(), w);
    }

    public void dumpSession(PrintStream out) {
        out.println("API Session with id: " + this.getId() + ", Attributes: " + this.attributes);
        for (AttributeWrapper a : this.attributes.values()) {
            System.out.println(a.getKey() + " = " + a.getValue());
        }
    }

    public void dumpSession(Logger log) {
        log.debug("API Session with id: " + this.getId() + ", Attributes: " + this.attributes);
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String aReferenceId) {
        this.referenceId = aReferenceId;
    }

    @Override
    public String getCurrentUserId() {
        return this.currentUserId;
    }

    public void setCurrentUserId(String aCurrentUserId) {
        boolean isDifferent = this.isChanged(this.currentUserId, aCurrentUserId);
        this.currentUserId = aCurrentUserId;
        if (this.sessionCallBack != null && isDifferent) {
            this.sessionCallBack.currentUserIdChanged(this.getId(), this.currentUserId);
        }
    }

    @Override
    public String getCurrentEditorId() {
        return this.currentEditorId;
    }

    public void setCurrentEditorId(String aCurrentEditorId) {
        boolean isDifferent = this.isChanged(this.currentEditorId, aCurrentEditorId);
        this.currentEditorId = aCurrentEditorId;
        if (this.sessionCallBack != null && isDifferent) {
            this.sessionCallBack.editorIdChanged(this.getId(), this.currentEditorId);
        }
    }

    public void addAttributeToActionScope(String name, Object attribute) {
        this.actionScope.put(name, attribute);
    }

    public Map<String, Object> getActionScope() {
        return this.actionScope;
    }

    public void resetActionScope() {
        this.actionScope.clear();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale aLocale) {
        this.locale = aLocale;
    }

    protected void setSessionCallBack(APISessionCallBack sessionCallBack) {
        this.sessionCallBack = sessionCallBack;
    }

    private <T> boolean isChanged(T value1, T value2) {
        return value1 != null && !value1.equals(value2) || value2 != null && !value2.equals(value1);
    }

    private boolean canDistribute(AttributeWrapper wrapper) {
        return this.sessionCallBack != null && wrapper != null && PolicyHelper.isDistributed(wrapper.getPolicy());
    }

    protected static interface APISessionCallBack {
        public void attributeSet(String var1, AttributeWrapper var2);

        public void attributeRemoved(String var1, String var2);

        public void currentUserIdChanged(String var1, String var2);

        public void editorIdChanged(String var1, String var2);

        public void keepAliveCall(String var1);
    }
}

