/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.session;

import java.io.IOException;
import java.io.Serializable;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.session.APISessionDistributionException;
import net.anotheria.anoplass.api.session.APISessionImpl;
import net.anotheria.anoplass.api.session.AttributeWrapper;
import net.anotheria.anoplass.api.session.PolicyHelper;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionAttribute;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionVO;
import net.anotheria.anoprise.sessiondistributor.NoSuchDistributedSessionException;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorService;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceException;
import net.anotheria.anoprise.sessiondistributor.SessionsCountLimitReachedSessionDistributorServiceException;
import net.anotheria.net.util.ByteArraySerializer;
import org.distributeme.core.exception.DistributemeRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class APISessionDistributionHelper {
    private static SessionDistributorService distributorService;
    private static final Logger LOG;

    public static void setSessionDistributorService(SessionDistributorService aSessionDistributorService) {
        distributorService = aSessionDistributorService;
    }

    public static APISession restoreSession(String distributedSessionName, String callServiced) throws APISessionDistributionException {
        DistributedSessionVO distributedSession;
        if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
            LOG.warn("There is nothing to restore! SD - service is not configured! Relying on defaults.");
            return null;
        }
        try {
            distributedSession = distributorService.restoreDistributedSession(distributedSessionName, callServiced);
        }
        catch (SessionDistributorServiceException e) {
            LOG.warn("restoreSession(" + distributedSessionName + "," + callServiced + ")failed. Cause " + e.getMessage());
            throw new APISessionDistributionException(e);
        }
        catch (DistributemeRuntimeException dMeR) {
            LOG.warn("restoreSession(" + distributedSessionName + "," + callServiced + ") failed. [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug("", (Throwable)dMeR);
            }
            return null;
        }
        APISessionImpl sessionImpl = new APISessionImpl(distributedSession.getName());
        sessionImpl.setCurrentEditorId(distributedSession.getEditorId());
        sessionImpl.setCurrentUserId(distributedSession.getUserId());
        for (DistributedSessionAttribute attribute : distributedSession.getDistributedAttributes().values()) {
            try {
                AttributeWrapper wrapper = (AttributeWrapper)ByteArraySerializer.deserializeObject((byte[])attribute.getData());
                sessionImpl.setAttributeWrapper(wrapper);
            }
            catch (IOException e) {
                LOG.warn("restoreSession(" + distributedSessionName + "," + callServiced + ") FAILED. exception occurred attempting to deSerialize this attribute: " + attribute, (Throwable)e);
            }
        }
        return sessionImpl;
    }

    public static void addAttributeToDistributedSession(String sessionName, AttributeWrapper attributeToAdd) {
        block8: {
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            if (!PolicyHelper.isDistributed(attributeToAdd.getPolicy())) {
                return;
            }
            if (!attributeToAdd.isSerializable()) {
                LOG.warn("Attribute " + attributeToAdd.getKey() + " is marked as distributed but is not serializable, skipped.");
                return;
            }
            try {
                distributorService.addDistributedAttribute(sessionName, new DistributedSessionAttribute(attributeToAdd.getKey(), ByteArraySerializer.serializeObject((Serializable)attributeToAdd)));
            }
            catch (IOException e) {
                LOG.error("addAttributeToDistributedSession(" + sessionName + "," + attributeToAdd + ") failed.", (Throwable)e);
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn("addAttributeToDistributedSession(" + sessionName + "," + attributeToAdd + ") failed. Cause" + e.getMessage());
            }
            catch (SessionDistributorServiceException e) {
                LOG.error("addAttributeToDistributedSession(" + sessionName + "," + attributeToAdd + ") failed.", (Throwable)e);
            }
            catch (DistributemeRuntimeException dMeR) {
                LOG.warn("addAttributeToDistributedSession(" + sessionName + "," + attributeToAdd + ") failed [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug("", (Throwable)dMeR);
            }
        }
    }

    public static void removeAttributeFromDistributedSession(String sessionName, String attributeName) {
        block5: {
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            try {
                distributorService.removeDistributedAttribute(sessionName, attributeName);
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn("removeAttributeFromDistributedSession(" + sessionName + "," + attributeName + ") failed. Cause " + e.getMessage());
            }
            catch (SessionDistributorServiceException e) {
                LOG.error("removeAttributeFromDistributedSession(" + sessionName + "," + attributeName + ") failed.", (Throwable)e);
            }
            catch (DistributemeRuntimeException dMeR) {
                LOG.warn("removeAttributeFromDistributedSession(" + sessionName + "," + attributeName + ") failed [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("", (Throwable)dMeR);
            }
        }
    }

    public static void updateDistributedSessionUserId(String sessionName, String userId) {
        block5: {
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            try {
                distributorService.updateSessionUserId(sessionName, userId);
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn("updateDistributedSessionUserId(" + sessionName + "," + userId + ") failed. Cause " + e.getMessage());
            }
            catch (SessionDistributorServiceException e) {
                LOG.error("updateDistributedSessionUserId(" + sessionName + "," + userId + ") failed.", (Throwable)e);
            }
            catch (DistributemeRuntimeException dMeR) {
                LOG.warn("updateDistributedSessionUserId(" + sessionName + "," + userId + ") failed [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("", (Throwable)dMeR);
            }
        }
    }

    public static void updateDistributedSessionEditorId(String sessionName, String editor) {
        block5: {
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            try {
                distributorService.updateSessionEditorId(sessionName, editor);
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn("updateDistributedSessionEditorId( " + sessionName + "," + editor + ") failed. Cause " + e.getMessage());
            }
            catch (SessionDistributorServiceException e) {
                LOG.error("updateDistributedSessionEditorId( " + sessionName + "," + editor + ") failed.", (Throwable)e);
            }
            catch (DistributemeRuntimeException dMeR) {
                LOG.warn("updateDistributedSessionEditorId(" + sessionName + "," + editor + ") failed [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("", (Throwable)dMeR);
            }
        }
    }

    public static void keepSessionAliveCall(String sessionName) {
        block5: {
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            try {
                distributorService.keepDistributedSessionAlive(sessionName);
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn("keepSessionAliveCall( " + sessionName + ") failed. Cause " + e.getMessage());
            }
            catch (SessionDistributorServiceException e) {
                LOG.error("keepSessionAliveCall( " + sessionName + ") failed.", (Throwable)e);
            }
            catch (DistributemeRuntimeException dMeR) {
                LOG.warn("keepSessionAliveCall(" + sessionName + ") failed [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("", (Throwable)dMeR);
            }
        }
    }

    public static String createSession(String aSessionId) throws APISessionDistributionException {
        if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
            LOG.warn("Distributed session can't be created! SD - not configured! Relying on defaults!");
            return null;
        }
        try {
            return distributorService.createDistributedSession(aSessionId);
        }
        catch (SessionsCountLimitReachedSessionDistributorServiceException sclRSDsE) {
            LOG.warn("createSession(" + aSessionId + ") failed [" + ((Object)((Object)sclRSDsE)).getClass().getName() + "]-  Returning same Id without remote session creation!" + sclRSDsE.getMessage());
            return aSessionId;
        }
        catch (SessionDistributorServiceException e) {
            throw new APISessionDistributionException(e);
        }
        catch (DistributemeRuntimeException dMeR) {
            LOG.warn("createSession(" + aSessionId + ") failed [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug("", (Throwable)dMeR);
            }
            return aSessionId;
        }
    }

    public static void removeDistributedSession(String aPISessionId) {
        block6: {
            if (!APISessionDistributionHelper.isSessionDistributorServiceConfigured()) {
                return;
            }
            try {
                distributorService.deleteDistributedSession(aPISessionId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DistributedSession " + aPISessionId + " removed.");
                }
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn("removeDistributedSession( " + aPISessionId + ") failed. Cause" + e.getMessage());
            }
            catch (SessionDistributorServiceException e) {
                LOG.error("removeDistributedSession( " + aPISessionId + ") failed", (Throwable)e);
            }
            catch (DistributemeRuntimeException dMeR) {
                LOG.warn("removeDistributedSession(" + aPISessionId + ") failed [" + ((Object)((Object)dMeR)).getClass().getName() + "] " + dMeR.getMessage());
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug("", (Throwable)dMeR);
            }
        }
    }

    protected static boolean isSessionDistributorServiceConfigured() {
        if (distributorService == null) {
            LOG.warn("SessionDistributorService is not configured! Working in local mode. Please configure SD - properly.");
            return false;
        }
        return true;
    }

    private APISessionDistributionHelper() {
        throw new IllegalAccessError("Not possible");
    }

    static {
        LOG = LoggerFactory.getLogger(APISessionDistributionHelper.class);
    }
}

