/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.session;

import net.anotheria.util.TimeUnit;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="ano-plass-api-session-distribution")
public final class APISessionDistributionConfig {
    protected static final int DEFAULT_API_SESSION_EVENT_SENDER_CHANNEL_Q_SIZE = 5000;
    protected static final long DEFAULT_API_SESSION_EVENT_SENDER_CHANNEL_Q_SLEEP_TIME = 300L;
    protected static final int DEFAULT_SESSION_DISTRIBUTOR_EVENT_RECEIVER_Q_SIZE = 5000;
    protected static final long DEFAULT_SESSION_DISTRIBUTOR_EVENT_RECEIVER_Q_SLEEP = 300L;
    private static final String DEFAULT_SESSION_ID_COOKIE_NAE = "a_s_id";
    private static final String DEFAULT_DISTRIBUTED_SESSION_ID_PARAM_NAME = "asDiSeName";
    @Configure
    private boolean distributionEnabled = false;
    @Configure
    private String sessionIdCookieName = "a_s_id";
    @Configure
    private String distributedSessionParameterName = "asDiSeName";
    @Configure
    private int apiSessionEventSenderQueueSize = 5000;
    @Configure
    private long apiSessionEventSenderQueueSleepTime = 300L;
    @Configure
    private int apiSessionEventSenderQueueProcessingChannelsAmount = 10;
    @Configure
    private int sessionDistributorEventReceiverQueueSize = 5000;
    @Configure
    private long sessionDistributorEventReceiverQueueSleepTime = 300L;
    @Configure
    private long distributedSessionKeepAliveCallInterval = TimeUnit.MINUTE.getMillis() * 5L;
    @Configure
    private String sessionIdCookieDomain = "";
    private static APISessionDistributionConfig configuration;

    public static synchronized APISessionDistributionConfig getInstance() {
        if (configuration == null) {
            configuration = new APISessionDistributionConfig();
            try {
                ConfigurationManager.INSTANCE.configure((Object)configuration);
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(APISessionDistributionConfig.class).warn("SessionDistribution is not configured, check ano-plass-api-session-distribution.json");
            }
            catch (Exception e) {
                LoggerFactory.getLogger(APISessionDistributionConfig.class).error("Configuration failure.", (Throwable)e);
            }
        }
        return configuration;
    }

    private APISessionDistributionConfig() {
    }

    public boolean isDistributionEnabled() {
        return this.distributionEnabled;
    }

    public void setDistributionEnabled(boolean aDistributionEnabled) {
        this.distributionEnabled = aDistributionEnabled;
    }

    public String getSessionIdCookieName() {
        return this.sessionIdCookieName;
    }

    public void setSessionIdCookieName(String aSessionIdCookieName) {
        this.sessionIdCookieName = aSessionIdCookieName;
    }

    public String getDistributedSessionParameterName() {
        return this.distributedSessionParameterName;
    }

    public void setDistributedSessionParameterName(String distributedSessionParameterName) {
        this.distributedSessionParameterName = distributedSessionParameterName;
    }

    public int getApiSessionEventSenderQueueSize() {
        return this.apiSessionEventSenderQueueSize;
    }

    public void setApiSessionEventSenderQueueSize(int aApiSessionEventSenderQueueSize) {
        this.apiSessionEventSenderQueueSize = aApiSessionEventSenderQueueSize;
    }

    public long getApiSessionEventSenderQueueSleepTime() {
        return this.apiSessionEventSenderQueueSleepTime;
    }

    public void setApiSessionEventSenderQueueSleepTime(long aApiSessionEventSenderQueueSleepTime) {
        this.apiSessionEventSenderQueueSleepTime = aApiSessionEventSenderQueueSleepTime;
    }

    public int getApiSessionEventSenderQueueProcessingChannelsAmount() {
        return this.apiSessionEventSenderQueueProcessingChannelsAmount;
    }

    public void setApiSessionEventSenderQueueProcessingChannelsAmount(int aApiSessionEventSenderQueueProcessingChannelsAmount) {
        this.apiSessionEventSenderQueueProcessingChannelsAmount = aApiSessionEventSenderQueueProcessingChannelsAmount;
    }

    public int getSessionDistributorEventReceiverQueueSize() {
        return this.sessionDistributorEventReceiverQueueSize;
    }

    public void setSessionDistributorEventReceiverQueueSize(int aSessionDistributorEventReceiverQueueSize) {
        this.sessionDistributorEventReceiverQueueSize = aSessionDistributorEventReceiverQueueSize;
    }

    public long getSessionDistributorEventReceiverQueueSleepTime() {
        return this.sessionDistributorEventReceiverQueueSleepTime;
    }

    public void setSessionDistributorEventReceiverQueueSleepTime(long aSessionDistributorEventReceiverQueueSleepTime) {
        this.sessionDistributorEventReceiverQueueSleepTime = aSessionDistributorEventReceiverQueueSleepTime;
    }

    public long getDistributedSessionKeepAliveCallInterval() {
        return this.distributedSessionKeepAliveCallInterval;
    }

    public void setDistributedSessionKeepAliveCallInterval(long aDistributedSessionKeepAliveCallInterval) {
        this.distributedSessionKeepAliveCallInterval = aDistributedSessionKeepAliveCallInterval;
    }

    public String getSessionIdCookieDomain() {
        return this.sessionIdCookieDomain;
    }

    public void setSessionIdCookieDomain(String sessionIdCookieDomain) {
        this.sessionIdCookieDomain = sessionIdCookieDomain;
    }
}

