/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.mock;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoplass.api.API;
import net.anotheria.anoplass.api.mock.APIMockMethod;
import net.anotheria.anoplass.api.mock.NoopMockMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockMethodRegistry {
    private static Logger log = LoggerFactory.getLogger(MockMethodRegistry.class);
    private static Map<Method, APIMockMethod> methods = new ConcurrentHashMap<Method, APIMockMethod>();

    public static void addMockMethod(Method m, APIMockMethod mock) {
        methods.put(m, mock);
    }

    public static APIMockMethod getMockMethod(Method m) {
        return methods.get(m);
    }

    public static void reset() {
        try {
            Method init = API.class.getMethod("init", new Class[0]);
            MockMethodRegistry.addMockMethod(init, new NoopMockMethod());
        }
        catch (NoSuchMethodException e) {
            log.error("Someone changed the api signature!", (Throwable)e);
        }
    }

    static {
        MockMethodRegistry.reset();
    }
}

