/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.mock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.anotheria.anoplass.api.API;
import net.anotheria.anoplass.api.APIException;
import net.anotheria.anoplass.api.mock.APIMockMethod;
import net.anotheria.anoplass.api.mock.MockMethodRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIMockImpl<T extends API>
implements API,
InvocationHandler {
    private Class<T> mockedClazz;
    private static Logger log = LoggerFactory.getLogger(APIMockImpl.class);

    public APIMockImpl(Class<T> aMockedClazz) {
        this.mockedClazz = aMockedClazz;
    }

    @Override
    public void deInit() {
    }

    @Override
    public void init() {
    }

    public T createAPIProxy() {
        return (T)((API)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.mockedClazz}, (InvocationHandler)this));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(this.mockedClazz) || method.getDeclaringClass().equals(API.class)) {
            return this.invokeOnMock(proxy, method, args);
        }
        return method.invoke((Object)this, args);
    }

    private Object invokeOnMock(Object proxy, Method method, Object[] args) throws APIException {
        APIMockMethod meth;
        if (log.isDebugEnabled()) {
            log.debug("Called method: " + method + " in " + this.mockedClazz.getName());
        }
        if ((meth = MockMethodRegistry.getMockMethod(method)) == null) {
            throw new IllegalArgumentException("Method " + method + " is not mocked");
        }
        return meth.invoke(method, args);
    }
}

