/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.mock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.anotheria.anoplass.api.API;
import net.anotheria.anoplass.api.APIInitException;
import net.anotheria.anoplass.api.mock.APIMaskMethod;
import net.anotheria.anoplass.api.mock.APIMockImpl;
import net.anotheria.anoplass.api.mock.MaskMethodRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIMaskImpl<T extends API>
implements API,
InvocationHandler {
    private T maskedInstance;
    private Class<T> maskedClazz;
    private static Logger log = LoggerFactory.getLogger(APIMockImpl.class);

    public APIMaskImpl(T aMaskedInstance, Class<T> aMaskedClazz) {
        this.maskedInstance = aMaskedInstance;
        this.maskedClazz = aMaskedClazz;
    }

    @Override
    public void deInit() {
        this.maskedInstance.deInit();
    }

    @Override
    public void init() throws APIInitException {
        this.maskedInstance.init();
    }

    public T createAPIProxy() {
        return (T)((API)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.maskedClazz}, (InvocationHandler)this));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getDeclaringClass().equals(this.maskedClazz) || method.getDeclaringClass().equals(API.class)) {
                return this.invokeOnMasked(proxy, method, args);
            }
            return method.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Object invokeOnMasked(Object proxy, Method method, Object[] args) throws Throwable {
        APIMaskMethod<?> meth;
        if (log.isDebugEnabled()) {
            log.debug("Called method: " + method + " in " + this.maskedClazz.getName());
        }
        if ((meth = MaskMethodRegistry.getMaskMethod(method)) == null) {
            return method.invoke(this.maskedInstance, args);
        }
        return meth.invoke(method, args, this.maskedInstance);
    }
}

