/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.generic.observation;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoplass.api.APIInitException;
import net.anotheria.anoplass.api.AbstractAPIImpl;
import net.anotheria.anoplass.api.generic.observation.ObservationAPI;
import net.anotheria.anoplass.api.generic.observation.Observer;
import net.anotheria.anoplass.api.generic.observation.SubjectUpdateEvent;
import net.anotheria.moskito.core.util.storage.Storage;

public class ObservationAPIImpl
extends AbstractAPIImpl
implements ObservationAPI {
    private Storage<String, List<Observer>> subjects;

    @Override
    public void init() throws APIInitException {
        super.init();
        this.subjects = Storage.createConcurrentHashMapStorage((String)"subjects");
    }

    @Override
    public void fireSubjectUpdateForCurrentUser(String subject, String originator) {
        this.log.debug("Firing update event for current user, originator: " + originator + " and subject: " + subject);
        List observers = (List)this.subjects.get((Object)subject);
        if (observers == null || observers.size() == 0) {
            return;
        }
        SubjectUpdateEvent event = new SubjectUpdateEvent(subject, originator);
        for (Observer anObserver : observers) {
            try {
                anObserver.notifySubjectUpdatedForCurrentUser(event);
            }
            catch (Exception e) {
                this.log.warn("(Uncaught exception in observer: " + anObserver + " .notifySubjectUpdatedForCurrentUser(" + event + ")", (Throwable)e);
            }
        }
    }

    @Override
    public void fireSubjectUpdateForUser(String subject, String originator, String userId) {
        this.log.debug("Firing update event for user " + userId + ", originator: " + originator + " and subject: " + subject);
        List observers = (List)this.subjects.get((Object)subject);
        if (observers == null || observers.size() == 0) {
            return;
        }
        SubjectUpdateEvent event = new SubjectUpdateEvent(subject, originator, userId);
        for (Observer anObserver : observers) {
            try {
                anObserver.notifySubjectUpdatedForUser(event);
            }
            catch (Exception e) {
                this.log.warn("(Uncaught exception in observer: " + anObserver + " .notifySubjectUpdatedForCurrentUser(" + event + ")", (Throwable)e);
            }
        }
    }

    @Override
    public void unRegisterObserver(Observer observer, String ... someSubjects) {
        for (String subject : someSubjects) {
            this.unRegisterObserver(observer, subject);
        }
    }

    private void unRegisterObserver(Observer observer, String subject) {
        this.log.debug("Unregistering observer: " + observer + ", for subject: " + subject);
        List observers = (List)this.subjects.get((Object)subject);
        if (observers == null || observers.size() == 0) {
            return;
        }
        observers.remove(observer);
    }

    @Override
    public void registerObserver(Observer observer, String ... someSubjects) {
        for (String subject : someSubjects) {
            this.registerObserver(subject, observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerObserver(String subject, Observer observer) {
        this.log.debug("Registering observer: " + observer + ", for subject: " + subject);
        CopyOnWriteArrayList<Observer> observers = (CopyOnWriteArrayList<Observer>)this.subjects.get((Object)subject);
        if (observers == null) {
            Storage<String, List<Observer>> storage = this.subjects;
            synchronized (storage) {
                observers = (List)this.subjects.get((Object)subject);
                if (observers == null) {
                    observers = new CopyOnWriteArrayList<Observer>();
                    this.subjects.put((Object)subject, observers);
                }
            }
        } else if (observers.indexOf(observer) != -1) {
            this.log.debug("Observer " + observer + " was already registered, skipping. ");
            return;
        }
        observers.add(observer);
    }
}

