/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.generic.login;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoplass.api.APIException;
import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anoplass.api.APIInitException;
import net.anotheria.anoplass.api.AbstractAPIImpl;
import net.anotheria.anoplass.api.NoLoggedInUserException;
import net.anotheria.anoplass.api.generic.login.LoginAPI;
import net.anotheria.anoplass.api.generic.login.LoginPostProcessor;
import net.anotheria.anoplass.api.generic.login.LoginPreProcessor;
import net.anotheria.anoplass.api.generic.login.LogoutPostProcessor;
import net.anotheria.anoplass.api.generic.login.LogoutPreProcessor;
import net.anotheria.anoplass.api.generic.login.ProcessorException;
import net.anotheria.anoplass.api.generic.login.processors.SessionCleanupOnLogoutProcessor;
import net.anotheria.anoplass.api.generic.observation.ObservationAPI;
import net.anotheria.anoplass.api.session.APISessionImpl;
import net.anotheria.util.StringUtils;

public class LoginAPIImpl
extends AbstractAPIImpl
implements LoginAPI {
    private List<LoginPreProcessor> loginPreProcessors;
    private List<LoginPostProcessor> loginPostProcessors;
    private List<LogoutPreProcessor> logoutPreProcessors;
    private List<LogoutPostProcessor> logoutPostProcessors;
    private ObservationAPI observationAPI;

    @Override
    public void init() throws APIInitException {
        super.init();
        this.loginPreProcessors = new CopyOnWriteArrayList<LoginPreProcessor>();
        this.loginPostProcessors = new CopyOnWriteArrayList<LoginPostProcessor>();
        this.logoutPreProcessors = new CopyOnWriteArrayList<LogoutPreProcessor>();
        this.logoutPostProcessors = new CopyOnWriteArrayList<LogoutPostProcessor>();
        this.addLogoutPostprocessor(new SessionCleanupOnLogoutProcessor());
        this.observationAPI = APIFinder.findAPI(ObservationAPI.class);
    }

    @Override
    public void addLoginPostprocessor(LoginPostProcessor postProcessor) {
        this.loginPostProcessors.add(postProcessor);
    }

    @Override
    public void addLoginPreprocessor(LoginPreProcessor preProcessor) {
        this.loginPreProcessors.add(preProcessor);
    }

    @Override
    public void logInUser(String userId) throws APIException {
        this.logInUser(userId, false);
    }

    @Override
    public void stealthLogInUser(String userId) throws APIException {
        this.logInUser(userId, true);
    }

    private void logInUser(String userId, boolean stealth) throws APIException {
        if (!stealth) {
            this.callLoginPreprocessors(userId);
        }
        ((APISessionImpl)this.getSession()).setCurrentUserId(userId);
        this.getCallContext().setCurrentUserId(userId);
        if (!stealth) {
            this.callLoginPostprocessors(userId);
        }
        if (!stealth) {
            this.observationAPI.fireSubjectUpdateForCurrentUser("login", this.getClass().getName());
        }
    }

    @Override
    public void logoutMe() throws APIException {
        try {
            String userId = this.getCallContext().getCurrentUserId();
            this.callLogoutPreprocessors(userId);
            ((APISessionImpl)this.getSession()).setCurrentUserId(null);
            this.getCallContext().setCurrentUserId(null);
            this.callLogoutPostprocessors(userId);
            this.observationAPI.fireSubjectUpdateForCurrentUser("logout", this.getClass().getName());
            if (!StringUtils.isEmpty((String)userId)) {
                this.observationAPI.fireSubjectUpdateForUser("logout", this.getClass().getName(), userId);
            }
        }
        catch (NoLoggedInUserException ignored) {
            this.log.trace("user not logged in", (Throwable)ignored);
        }
    }

    @Override
    public String getLogedUserId() throws NoLoggedInUserException {
        if (!this.isLogedIn()) {
            throw new NoLoggedInUserException("No loged in users!");
        }
        return this.getCallContext().getCurrentUserId();
    }

    @Override
    public boolean isLogedIn() {
        return !StringUtils.isEmpty((String)this.getCallContext().getCurrentUserId());
    }

    @Override
    public void addLogoutPostprocessor(LogoutPostProcessor postProcessor) {
        this.logoutPostProcessors.add(postProcessor);
    }

    @Override
    public void addLogoutPreprocessor(LogoutPreProcessor preProcessor) {
        this.logoutPreProcessors.add(preProcessor);
    }

    private void callLoginPreprocessors(String userId) throws APIException {
        for (LoginPreProcessor p : this.loginPreProcessors) {
            try {
                p.preProcessLogin(userId);
            }
            catch (ProcessorException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Exception in loginpreprocessor: " + p, (Throwable)e);
            }
        }
    }

    private void callLoginPostprocessors(String userId) {
        for (LoginPostProcessor p : this.loginPostProcessors) {
            try {
                p.postProcessLogin(userId);
            }
            catch (Exception e) {
                this.log.error("Exception in loginpostprocessor: " + p, (Throwable)e);
            }
        }
    }

    private void callLogoutPreprocessors(String userId) throws APIException {
        for (LogoutPreProcessor p : this.logoutPreProcessors) {
            try {
                p.preProcessLogout(userId);
            }
            catch (ProcessorException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Exception in logoutPreProcessor: " + p, (Throwable)e);
            }
        }
    }

    private void callLogoutPostprocessors(String userId) {
        for (LogoutPostProcessor p : this.logoutPostProcessors) {
            try {
                p.postProcessLogout(userId);
            }
            catch (Exception e) {
                this.log.error("Exception in logoutpostprocessor: " + p, (Throwable)e);
            }
        }
    }
}

