/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anoplass.api.activity.ActivityAPI;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.session.APISessionCreationException;
import net.anotheria.anoplass.api.session.APISessionDistributionConfig;
import net.anotheria.anoplass.api.session.APISessionManager;
import net.anotheria.util.StringUtils;
import net.anotheria.util.concurrency.IdBasedLock;
import net.anotheria.util.concurrency.IdBasedLockManager;
import net.anotheria.util.concurrency.SafeIdBasedLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIFilter
implements Filter {
    @Deprecated
    public static final String PARAM_COPY_SESSION = "srcsession";
    public static final String API_SESSION_ID_HTTP_SESSION_ATTRIBUTE_NAME = "API_SESSION_ID";
    public static final String API_SESSION_HTTP_SESSION_ATTRIBUTE_NAME = "API_SESSION";
    private static final String USER_AGENT_HEADER_CONSTANT = "user-agent";
    private ActivityAPI activityAPI;
    private static final String CURRENT_USER_ID = "currentUserId";
    private static final Logger LOG = LoggerFactory.getLogger(APIFilter.class);
    private IdBasedLockManager<String> lockManager;
    private APISessionDistributionConfig configuration;

    public void destroy() {
    }

    public void doFilter(ServletRequest sReq, ServletResponse sRes, FilterChain chain) throws IOException, ServletException {
        if (!(sReq instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sReq;
        APISession session = this.initSession(req);
        String url = req.getRequestURL().toString();
        String qs = req.getQueryString();
        if (!StringUtils.isEmpty((String)qs)) {
            url = url + qs;
        }
        this.activityAPI.notifyMyActivity(url);
        if (!(sRes instanceof HttpServletResponse)) {
            return;
        }
        this.saveCookie((HttpServletResponse)HttpServletResponse.class.cast(sRes), req, session);
        chain.doFilter(sReq, sRes);
    }

    private void saveCookie(HttpServletResponse res, HttpServletRequest req, APISession session) {
        if (!this.configuration.isDistributionEnabled()) {
            return;
        }
        Cookie distributedSessionCookie = this.getDistributedSessionIdCookie(req);
        if (distributedSessionCookie == null) {
            this.addSessionIdCookieToResponse(res, session.getId());
            return;
        }
        if (!session.getId().equals(distributedSessionCookie.getValue())) {
            distributedSessionCookie.setMaxAge(0);
            this.addSessionIdCookieToResponse(res, session.getId());
        }
    }

    private void addSessionIdCookieToResponse(HttpServletResponse sres, String sessionId) {
        Cookie distributedSessionCookie = new Cookie(this.configuration.getSessionIdCookieName(), sessionId);
        distributedSessionCookie.setPath("/");
        distributedSessionCookie.setMaxAge(-1);
        if (!StringUtils.isEmpty((String)this.configuration.getSessionIdCookieDomain())) {
            distributedSessionCookie.setDomain(this.configuration.getSessionIdCookieDomain());
        }
        sres.addCookie(distributedSessionCookie);
    }

    public void init(FilterConfig config) throws ServletException {
        this.activityAPI = APIFinder.findAPI(ActivityAPI.class);
        this.configuration = APISessionDistributionConfig.getInstance();
        this.lockManager = new SafeIdBasedLockManager();
    }

    protected APISession initSession(HttpServletRequest req) throws ServletException {
        HttpSession session = req.getSession(true);
        if (session == null) {
            throw new ServletException("Could not obtain HttpSession!");
        }
        IdBasedLock lock = this.lockManager.obtainLock((Object)session.getId());
        lock.lock();
        try {
            String editorId;
            Object apiSessionIdObject = session.getAttribute(API_SESSION_ID_HTTP_SESSION_ATTRIBUTE_NAME);
            String apiSessionId = String.class.isInstance(apiSessionIdObject) ? (String)String.class.cast(apiSessionIdObject) : null;
            String dSessionIdFromCookies = this.getDistributedSessionIdFromCookies(req);
            String dSessionIdFromRequest = req.getParameter(this.configuration.getDistributedSessionParameterName());
            String userAgent = req.getHeader(USER_AGENT_HEADER_CONSTANT);
            String string = editorId = session.getAttribute(CURRENT_USER_ID) instanceof String ? (String)String.class.cast(session.getAttribute(CURRENT_USER_ID)) : null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("apiSessionId : " + apiSessionId);
                LOG.debug("dSessionIdFromCookies : " + dSessionIdFromCookies);
                LOG.debug("dSessionIdFromRequest : " + dSessionIdFromRequest);
                LOG.debug("userAgent : " + userAgent);
                LOG.debug("editorId : " + editorId);
            }
            APISession apiSession = APISessionManager.getInstance().obtainSession(session.getId(), apiSessionId, dSessionIdFromCookies, dSessionIdFromRequest, req.getRemoteAddr(), userAgent, req.getLocale(), editorId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("APISession - successfully obtained!");
            }
            session.setAttribute(API_SESSION_ID_HTTP_SESSION_ATTRIBUTE_NAME, (Object)apiSession.getId());
            APISession aPISession = apiSession;
            return aPISession;
        }
        catch (APISessionCreationException e) {
            LOG.error("obtainSession(" + session + ")", (Throwable)e);
            throw new ServletException("APISession obtain failed! " + e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private String getDistributedSessionIdFromCookies(HttpServletRequest req) {
        Cookie sessionIdCookie = this.getDistributedSessionIdCookie(req);
        return sessionIdCookie != null ? sessionIdCookie.getValue() : null;
    }

    private Cookie getDistributedSessionIdCookie(HttpServletRequest req) {
        if (!this.configuration.isDistributionEnabled()) {
            return null;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        Cookie sessionIdCookie = null;
        for (Cookie curr : cookies) {
            if (!curr.getName().equals(this.configuration.getSessionIdCookieName())) continue;
            sessionIdCookie = curr;
        }
        return sessionIdCookie;
    }
}

