/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api;

import java.util.Locale;
import net.anotheria.anoplass.api.API;
import net.anotheria.anoplass.api.APICallContext;
import net.anotheria.anoplass.api.APIConfig;
import net.anotheria.anoplass.api.APIInitException;
import net.anotheria.anoplass.api.NoLoggedInUserException;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.session.PolicyHelper;
import net.anotheria.anoplass.api.validation.ValidationError;
import net.anotheria.anoplass.api.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAPIImpl
implements API {
    protected Logger log;
    private final String ATTRIBUTE_PREFIX = this.getClass().getName() + ".";
    private static APIConfig apiConfig;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;

    protected AbstractAPIImpl() {
        this.log = LoggerFactory.getLogger(this.getClass());
        apiConfig = new APIConfig();
    }

    @Override
    public void deInit() {
    }

    @Override
    public void init() throws APIInitException {
    }

    protected void setAttributeInSession(String name, Object attribute) {
        this.getSession().setAttribute(this.getPrivateAttributeName(name), attribute);
    }

    protected void setAttributeInSession(String name, int policy, Object attribute) {
        if (PolicyHelper.isAutoExpiring(policy)) {
            this.setAttributeInSession(name, policy, attribute, System.currentTimeMillis() + this.getExpirePeriodForAttribute(name));
        } else {
            this.getSession().setAttribute(this.getPrivateAttributeName(name), policy, attribute);
        }
    }

    protected void setAttributeInSession(String name, int policy, Object attribute, long expiresWhen) {
        this.getSession().setAttribute(this.getPrivateAttributeName(name), policy, attribute, expiresWhen);
    }

    protected void setAttributeInSession(String name, Object attribute, long expiresWhen) {
        this.setAttributeInSession(name, 8, attribute, expiresWhen);
    }

    protected Object getAttributeFromSession(String name) {
        return this.getSession().getAttribute(this.getPrivateAttributeName(name));
    }

    public void removeAttributeFromSession(String key) {
        this.getSession().removeAttribute(this.getPrivateAttributeName(key));
    }

    private String getSessionAttributePrefix() {
        return this.ATTRIBUTE_PREFIX;
    }

    protected String getPrivateAttributeName(String name) {
        return this.getSessionAttributePrefix() + name;
    }

    protected APICallContext getCallContext() {
        return APICallContext.getCallContext();
    }

    protected APISession getSession() {
        return this.getCallContext().getCurrentSession();
    }

    protected Locale getCurrentLocale() {
        return this.getCallContext().getCurrentLocale();
    }

    protected String getCurrentUserId() {
        return this.getCallContext().getCurrentUserId();
    }

    protected String getLoggedInUserId() throws NoLoggedInUserException {
        String userId = this.getCurrentUserId();
        if (userId == null || userId.length() == 0) {
            throw new NoLoggedInUserException("No logged in user.");
        }
        return userId;
    }

    protected long getExpirePeriodForAttribute(String name) {
        return this.getDefaultExpirePeriodForAttribute();
    }

    protected long getDefaultExpirePeriodForAttribute() {
        return APISession.DEFAULT_EXPIRE_PERIOD;
    }

    protected static APIConfig getApiConfig() {
        return apiConfig;
    }

    protected void addValidationError(String field, String cmsKey, String description) {
        this.addValidationError(new ValidationError(field, cmsKey, description));
    }

    protected void addValidationError(ValidationError error) {
        APICallContext.getCallContext().addValidationError(error);
    }

    protected void checkValidationAndThrowException() throws ValidationException {
        if (APICallContext.getCallContext().hasValidationErrors()) {
            throw new ValidationException(APICallContext.getCallContext().getValidationErrors());
        }
    }
}

