/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anoplass.api.API;
import net.anotheria.anoplass.api.APICallHandler;
import net.anotheria.anoplass.api.APIConfig;
import net.anotheria.anoplass.api.APIException;
import net.anotheria.anoplass.api.APIFactory;
import net.anotheria.anoplass.api.APIInitializationException;
import net.anotheria.anoplass.api.NoAPIFactoryException;
import net.anotheria.anoplass.api.mock.APIMaskImpl;
import net.anotheria.anoplass.api.mock.APIMockImpl;
import net.anotheria.anoplass.api.mock.MaskMethodRegistry;
import net.anotheria.anoplass.api.mock.MockMethodRegistry;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandlerWithCallSysout;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class APIFinder {
    private static Map<Class<? extends API>, API> apis;
    private static Map<Class<? extends API>, APIFactory<? extends API>> factories;
    private static Logger log;
    private static boolean maskingEnabled;
    private static boolean mockingEnabled;
    private static boolean securityEnabled;

    public static API findAPI(String identifier) throws APIException {
        try {
            return APIFinder.findAPI(Class.forName(identifier));
        }
        catch (ClassNotFoundException e) {
            throw new NoAPIFactoryException("Class not found: " + identifier + ", exception: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends API> T findAPI(Class<T> identifier) {
        log.debug("find api: " + identifier);
        API loaded = apis.get(identifier);
        log.debug(" loaded: " + loaded);
        if (loaded != null) {
            return (T)loaded;
        }
        Map<Class<? extends API>, API> map = apis;
        synchronized (map) {
            API doubleChecked = apis.get(identifier);
            log.debug("\t doubleChecked: " + doubleChecked);
            if (doubleChecked != null) {
                return (T)doubleChecked;
            }
            T created = APIFinder.createAPI(identifier);
            log.info(" created api: " + created + " for " + identifier);
            apis.put((Class<? extends API>)identifier, (API)created);
            log.debug(" calling init " + identifier);
            try {
                created.init();
            }
            catch (Exception e) {
                log.error("findAPI.init in API " + identifier, (Throwable)e);
                throw new APIInitializationException(identifier, e);
            }
            log.debug("ready");
            return created;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized <T extends API> T createAPI(Class<T> identifier) throws NoAPIFactoryException {
        APIFactory<? extends API> factory = factories.get(identifier);
        if (factory == null) {
            if (APIFinder.isMockingEnabled()) {
                return APIFinder.createMockAPI(identifier);
            }
            throw new NoAPIFactoryException(identifier.getName());
        }
        log.debug("------ START creation API " + identifier);
        API newAPI = factory.createAPI();
        log.debug("\tcreated new instance: " + newAPI);
        if (APIFinder.isMaskingEnabled()) {
            APIMaskImpl<API> maskedAPI = new APIMaskImpl<API>(newAPI, identifier);
            newAPI = maskedAPI.createAPIProxy();
        }
        Class[] interfaces = null;
        try {
            List<Class<? extends API>> aliases = APIConfig.getAliases(identifier);
            if (aliases != null && aliases.size() > 0) {
                Class[] interfacesWithAliases = new Class[aliases.size() + 2];
                interfaces = interfacesWithAliases;
                int i = 2;
                for (Class<? extends API> a : aliases) {
                    interfaces[i++] = a;
                }
            } else {
                Class[] interfacesWithoutAliases;
                interfaces = interfacesWithoutAliases = new Class[2];
            }
            interfaces[0] = identifier;
            interfaces[1] = API.class;
            MoskitoInvokationProxy proxy = new MoskitoInvokationProxy((Object)newAPI, (IOnDemandCallHandler)(APIConfig.verboseMethodCalls() ? new ServiceStatsCallHandlerWithCallSysout() : new ServiceStatsCallHandler()), (IOnDemandStatsFactory)new ServiceStatsFactory(), identifier.getName().substring(identifier.getName().lastIndexOf(46) + 1), "api", "default", interfaces);
            API ret = (API)proxy.createProxy();
            API aPI = APICallHandler.createProxy(identifier, interfaces, ret);
            return (T)aPI;
        }
        catch (Throwable t) {
            log.debug("THROWABLE creating " + identifier, t);
            API aPI = APICallHandler.createProxy(identifier, interfaces, newAPI);
            return (T)aPI;
        }
        finally {
            log.debug("------ END creation API " + identifier + "\n");
        }
    }

    private static void init() {
        apis = new HashMap<Class<? extends API>, API>();
        factories = APIConfig.getFactories();
    }

    public static <T extends API> void addAPIFactory(Class<T> apiClass, APIFactory<T> factoryObject) {
        factories.put(apiClass, factoryObject);
    }

    static Collection<API> getAPIs() {
        return apis.values();
    }

    private static <T extends API> T createMockAPI(Class<T> identifier) {
        APIMockImpl<T> mock = new APIMockImpl<T>(identifier);
        return mock.createAPIProxy();
    }

    public static boolean isMaskingEnabled() {
        return maskingEnabled;
    }

    public static void setMaskingEnabled(boolean aMaskingEnabled) {
        maskingEnabled = aMaskingEnabled;
    }

    public static boolean isMockingEnabled() {
        return mockingEnabled;
    }

    public static void setMockingEnabled(boolean aMockingEnabled) {
        mockingEnabled = aMockingEnabled;
    }

    public static boolean isInTestingMode() {
        return APIFinder.isMockingEnabled() || APIFinder.isMaskingEnabled();
    }

    public static void cleanUp() {
        if (apis != null) {
            apis.clear();
        }
        if (factories != null) {
            factories.clear();
        }
        MockMethodRegistry.reset();
        MaskMethodRegistry.reset();
        mockingEnabled = false;
        maskingEnabled = false;
        securityEnabled = true;
        factories = APIConfig.getFactories();
    }

    public static void disableSecurity() {
        securityEnabled = false;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void enableSecurity() {
        securityEnabled = true;
    }

    private APIFinder() {
    }

    static {
        log = LoggerFactory.getLogger(APIFinder.class);
        APIFinder.init();
        maskingEnabled = false;
        mockingEnabled = false;
        securityEnabled = true;
    }
}

