/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anoplass.api.API;
import net.anotheria.anoplass.api.APIConfigurable;
import net.anotheria.anoplass.api.APIFactory;
import net.anotheria.anoplass.api.activity.ActivityAPI;
import net.anotheria.anoplass.api.activity.ActivityAPIFactory;
import net.anotheria.anoplass.api.generic.login.LoginAPI;
import net.anotheria.anoplass.api.generic.login.LoginAPIFactory;
import net.anotheria.anoplass.api.generic.observation.ObservationAPI;
import net.anotheria.anoplass.api.generic.observation.ObservationAPIFactory;
import org.configureme.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIConfig {
    public static final int SERVICE_POLICY_SINGLE_INSTANCE = 1;
    public static final int SERVICE_POLICY_MULTI_INSTANCE = 2;
    public static final int SERVICE_POLICY_DEFAULT = 2;
    private static int servicePolicy;
    private static Map<Class<? extends API>, List<Class<? extends API>>> aliasMap;
    private static APIConfigurable configurable;
    private static Logger log;

    private static void addAlias(Class<? extends API> interfaceClass, Class<? extends API> aliasClass) {
        List<Class<? extends API>> aliases = aliasMap.get(interfaceClass);
        if (aliases == null) {
            aliases = new ArrayList<Class<? extends API>>();
            aliasMap.put(interfaceClass, aliases);
        }
        aliases.add(aliasClass);
    }

    public static List<Class<? extends API>> getAliases(Class<? extends API> source) {
        return aliasMap.get(source);
    }

    public static Map<Class<? extends API>, APIFactory<? extends API>> getFactories() {
        HashMap<Class<? extends API>, APIFactory<? extends API>> ret = new HashMap<Class<? extends API>, APIFactory<? extends API>>();
        ret.put(ActivityAPI.class, new ActivityAPIFactory());
        ret.put(LoginAPI.class, new LoginAPIFactory());
        ret.put(ObservationAPI.class, new ObservationAPIFactory());
        return ret;
    }

    public static Map<Class<? extends API>, List<Class<? extends API>>> getInterfaceAliases() {
        return aliasMap;
    }

    public static int getServicePolicy() {
        return servicePolicy;
    }

    public static boolean verboseMethodCalls() {
        return configurable.isVerboseMethodCalls();
    }

    public static boolean associateSessions() {
        return configurable.isAssociateSessions();
    }

    static {
        log = LoggerFactory.getLogger(APIConfig.class);
        servicePolicy = 2;
        aliasMap = new HashMap<Class<? extends API>, List<Class<? extends API>>>();
        configurable = new APIConfigurable();
        try {
            ConfigurationManager.INSTANCE.configure((Object)configurable);
        }
        catch (IllegalArgumentException apiConfigNotFound) {
            log.warn("apiconfig not found, running with default values");
        }
    }
}

