/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.anoplass.api.API;
import net.anotheria.anoplass.api.APIFinder;
import net.anotheria.anoplass.api.NoAPIFactoryException;
import net.anotheria.anoplass.api.generic.security.EnsurePermitted;
import net.anotheria.anoplass.api.generic.security.InterceptIfNotPermitted;
import net.anotheria.anoplass.api.generic.security.SecurityAPI;
import net.anotheria.anoplass.api.generic.security.SecurityInvocationHandler;
import net.anotheria.anoplass.api.generic.security.SecurityObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APICallHandler<T extends API>
implements InvocationHandler {
    private T target;
    private ConcurrentMap<Method, MethodInfo> methodMap;
    private SecurityAPI securityAPI;
    private static Logger log = LoggerFactory.getLogger(APICallHandler.class);

    APICallHandler(T impl) {
        this.target = impl;
        this.methodMap = new ConcurrentHashMap<Method, MethodInfo>();
        if (!(impl instanceof SecurityAPI)) {
            try {
                this.securityAPI = APIFinder.findAPI(SecurityAPI.class);
            }
            catch (NoAPIFactoryException noAPIFactoryException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodInfo info = this.getMethodInfo(method);
        if (info.ensurePermitted()) {
            if (this.securityAPI == null) {
                log.warn("invoke(..., " + method + ", ...), can't find security api, probably misconfigured, security checks are disabled!");
            } else {
                this.securityAPI.ensureIsAllowedTo(info.ensurePermittedAnn.action(), this.createSecuritySubject(), this.createSecurityObject());
            }
        }
        if (info.interceptIfNotPermitted()) {
            if (this.securityAPI == null) {
                log.warn("invoke(..., " + method + ", ...), can't find security api, probably misconfigured, security checks are disabled!");
            } else {
                boolean permitted = this.securityAPI.isAllowedTo(info.interceptIfNotPermittedAnn.action(), this.createSecuritySubject(), this.createSecurityObject());
                if (!permitted) {
                    Object interceptedValue = info.securityHandler.getInterceptedValue(method, args, this.target);
                    return interceptedValue;
                }
            }
        }
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException t) {
            throw t.getCause();
        }
    }

    private SecurityObject createSecuritySubject() {
        return new SecurityObject();
    }

    private SecurityObject createSecurityObject() {
        return new SecurityObject();
    }

    private MethodInfo getMethodInfo(Method m) {
        MethodInfo fromCache = (MethodInfo)this.methodMap.get(m);
        if (fromCache != null) {
            return fromCache;
        }
        MethodInfo info = new MethodInfo(m);
        info.ensurePermittedAnn = m.getAnnotation(EnsurePermitted.class);
        info.interceptIfNotPermittedAnn = m.getAnnotation(InterceptIfNotPermitted.class);
        try {
            if (info.interceptIfNotPermitted()) {
                info.securityHandler = info.interceptIfNotPermittedAnn.handler().newInstance();
            }
        }
        catch (InstantiationException e) {
            log.error("getMethodInfo(" + m + ")", (Throwable)e);
            throw new IllegalStateException("Configured security handler can't be instantiated " + info.interceptIfNotPermittedAnn.handler(), e);
        }
        catch (IllegalAccessException e) {
            log.error("getMethodInfo(" + m + ")", (Throwable)e);
            throw new IllegalStateException("Configured security handler can't be instantiated " + info.interceptIfNotPermittedAnn.handler(), e);
        }
        this.methodMap.put(m, info);
        return info;
    }

    static <T extends API> T createProxy(Class<T> identifier, Class<? extends API>[] interfaces, T impl) {
        APICallHandler<T> handler = new APICallHandler<T>(impl);
        API ret = (API)Proxy.newProxyInstance(identifier.getClassLoader(), interfaces, handler);
        return (T)ret;
    }

    static class MethodInfo {
        private static final AtomicInteger instanceCounter = new AtomicInteger(0);
        private int instanceNumber = instanceCounter.incrementAndGet();
        private Method method;
        EnsurePermitted ensurePermittedAnn;
        InterceptIfNotPermitted interceptIfNotPermittedAnn;
        SecurityInvocationHandler securityHandler;

        public MethodInfo(Method aMethod) {
            this.method = aMethod;
        }

        public String toString() {
            return "MethodInfo " + this.method + " " + this.instanceNumber + " ensurePermitted: " + this.ensurePermitted() + ", interceptIfNotPermitted: " + this.interceptIfNotPermitted();
        }

        boolean ensurePermitted() {
            return this.ensurePermittedAnn != null;
        }

        boolean interceptIfNotPermitted() {
            return this.interceptIfNotPermittedAnn != null;
        }
    }
}

