/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoplass.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.anotheria.anoplass.api.session.APISession;
import net.anotheria.anoplass.api.validation.ValidationError;

public class APICallContext {
    public static final Locale DEFAULT_LOCALE = new Locale("en", "GB");
    private Locale currentLocale;
    private APISession currentSession;
    private String currentServerName;
    private Map<String, Object> scope = new HashMap<String, Object>();
    private String currentUserId;
    private String currentEditorId;
    private List<ValidationError> validationErrors;
    private static InheritableThreadLocal<APICallContext> apiCallContext = new InheritableThreadLocal<APICallContext>(){

        @Override
        protected synchronized APICallContext initialValue() {
            return new APICallContext();
        }

        @Override
        protected APICallContext childValue(APICallContext parentValue) {
            APICallContext ret = new APICallContext();
            ret.copyFromAnotherContext(parentValue);
            return ret;
        }
    };

    private APICallContext() {
        this.reset();
    }

    public String getCurrentUserId() {
        return this.currentUserId;
    }

    public void setCurrentUserId(String aCurrentUserId) {
        this.currentUserId = aCurrentUserId;
    }

    public String getCurrentEditorId() {
        return this.currentEditorId;
    }

    public void setCurrentEditorId(String aCurrentEditorId) {
        this.currentEditorId = aCurrentEditorId;
    }

    public void reset() {
        this.currentLocale = DEFAULT_LOCALE;
        this.currentServerName = "";
        this.currentSession = null;
        this.scope = new HashMap<String, Object>();
        this.currentUserId = null;
        this.currentEditorId = null;
        this.validationErrors = new ArrayList<ValidationError>();
    }

    public void setAttribute(String name, Object value) {
        this.scope.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.scope.get(name);
    }

    public void removeAttribute(String name) {
        this.scope.remove(name);
    }

    public Locale getCurrentLocale() {
        return this.currentLocale == null ? DEFAULT_LOCALE : this.currentLocale;
    }

    public void setCurrentLocale(Locale aCurrentLocale) {
        this.currentLocale = aCurrentLocale;
        if (this.currentSession != null) {
            this.currentSession.setLocale(this.currentLocale);
        }
    }

    public APISession getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(APISession aCurrentSession) {
        this.currentSession = aCurrentSession;
    }

    public String toString() {
        return "User: " + (this.isMember() ? this.getCurrentUserId() : "guest") + " session: " + this.currentSession + ", locale: " + this.currentLocale + ", serverName: " + this.currentServerName + ", scope contains " + this.scope.size() + " elements.";
    }

    public boolean isGuest() {
        return !this.isMember();
    }

    public boolean isMember() {
        return this.currentUserId != null;
    }

    public boolean isEditor() {
        return this.currentEditorId != null;
    }

    public void addValidationError(ValidationError error) {
        this.validationErrors.add(error);
    }

    public void addValidationErrors(List<ValidationError> errors) {
        this.validationErrors.addAll(errors);
    }

    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> someValidationErrors) {
        this.validationErrors = someValidationErrors;
    }

    public boolean hasValidationErrors() {
        return this.validationErrors.size() > 0;
    }

    public void resetValidationErrors() {
        this.validationErrors = new ArrayList<ValidationError>();
    }

    public String getCurrentServerName() {
        return this.currentServerName;
    }

    public void setCurrentServerName(String currentServerName) {
        this.currentServerName = currentServerName;
    }

    void copyFromAnotherContext(APICallContext anotherContext) {
        this.currentLocale = anotherContext.currentLocale;
        this.currentSession = anotherContext.currentSession;
        this.currentServerName = anotherContext.currentServerName;
        this.scope = new HashMap<String, Object>();
        this.scope.putAll(anotherContext.scope);
        this.currentUserId = anotherContext.currentUserId;
        this.currentEditorId = anotherContext.currentEditorId;
        this.validationErrors = new ArrayList<ValidationError>();
        this.validationErrors.addAll(anotherContext.validationErrors);
    }

    public static APICallContext getCallContext() {
        return (APICallContext)apiCallContext.get();
    }

    public static void remove() {
        apiCallContext.remove();
    }
}

