/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.contrib.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.contrib.hibernate.PersistentDateTime;

public class PersistentInterval
implements CompositeUserType,
Serializable {
    private static final String[] PROPERTY_NAMES = new String[]{"start", "end"};
    private static final Type[] TYPES = new Type[]{StandardBasicTypes.TIMESTAMP, StandardBasicTypes.TIMESTAMP};

    public Object assemble(Serializable serializable, SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return serializable;
    }

    public Object deepCopy(Object object) throws HibernateException {
        return object;
    }

    public Serializable disassemble(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        return (Serializable)object;
    }

    public boolean equals(Object object, Object object2) throws HibernateException {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public Type[] getPropertyTypes() {
        return TYPES;
    }

    public Object getPropertyValue(Object object, int n) throws HibernateException {
        Interval interval = (Interval)object;
        return n == 0 ? interval.getStart().toDate() : interval.getEnd().toDate();
    }

    public int hashCode(Object object) throws HibernateException {
        return object.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        if (resultSet == null) {
            return null;
        }
        PersistentDateTime persistentDateTime = new PersistentDateTime();
        DateTime dateTime = (DateTime)persistentDateTime.nullSafeGet(resultSet, stringArray[0]);
        DateTime dateTime2 = (DateTime)persistentDateTime.nullSafeGet(resultSet, stringArray[1]);
        if (dateTime == null || dateTime2 == null) {
            return null;
        }
        return new Interval((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, StandardBasicTypes.TIMESTAMP.sqlType());
            preparedStatement.setNull(n + 1, StandardBasicTypes.TIMESTAMP.sqlType());
            return;
        }
        Interval interval = (Interval)object;
        preparedStatement.setTimestamp(n, this.asTimeStamp(interval.getStart()));
        preparedStatement.setTimestamp(n + 1, this.asTimeStamp(interval.getEnd()));
    }

    private Timestamp asTimeStamp(DateTime dateTime) {
        return new Timestamp(dateTime.getMillis());
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3) throws HibernateException {
        return object;
    }

    public Class returnedClass() {
        return Interval.class;
    }

    public void setPropertyValue(Object object, int n, Object object2) throws HibernateException {
        throw new UnsupportedOperationException("Immutable Interval");
    }
}

